/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class DamageableShapelessOreRecipe
extends ShapelessOreRecipe {
    private final int[] damageAmounts;
    private final int[] invSlots;

    public DamageableShapelessOreRecipe(@Nullable ResourceLocation group, int[] damageAmounts, @Nonnull ItemStack result, Object ... recipe) {
        super(group, result, recipe);
        this.damageAmounts = damageAmounts;
        this.invSlots = new int[damageAmounts.length];
    }

    private DamageableShapelessOreRecipe(@Nullable ResourceLocation group, int[] damageAmounts, NonNullList<Ingredient> input, @Nonnull ItemStack result) {
        super(group, input, result);
        this.damageAmounts = damageAmounts;
        this.invSlots = new int[damageAmounts.length];
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList items = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.func_77569_a(inv, null);
        for (int i = 0; i < this.invSlots.length; ++i) {
            int amount = this.damageAmounts[i];
            int invIndex = this.invSlots[i];
            if (amount > 0) {
                ItemStack stack = inv.func_70301_a(invIndex).func_77946_l();
                stack.func_77964_b(stack.func_77952_i() + amount);
                if (stack.func_77952_i() > stack.func_77958_k()) {
                    stack = ForgeHooks.getContainerItem((ItemStack)stack);
                }
                items.set(invIndex, (Object)stack);
                continue;
            }
            items.set(invIndex, (Object)ForgeHooks.getContainerItem((ItemStack)inv.func_70301_a(invIndex)));
        }
        return items;
    }

    public boolean func_77569_a(InventoryCrafting var1, @Nullable World world) {
        LinkedHashMap required = Maps.newLinkedHashMap();
        for (int i = 0; i < this.input.size(); ++i) {
            required.put(i, this.input.get(i));
        }
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot.func_190926_b()) continue;
            boolean inRecipe = false;
            Iterator req = required.entrySet().iterator();
            while (req.hasNext()) {
                boolean match = false;
                Map.Entry nextEntry = req.next();
                Ingredient next = (Ingredient)nextEntry.getValue();
                int index = (Integer)nextEntry.getKey();
                int damage = this.damageAmounts[index];
                match = next.apply(slot) && damage <= slot.func_77958_k() - slot.func_77952_i() + 1;
                if (!match) continue;
                this.invSlots[index] = x;
                inRecipe = true;
                required.remove(index);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList ings = NonNullList.func_191196_a();
            for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ings.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
            }
            if (ings.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack itemstack = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            int[] damage = new int[ings.size()];
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"damage")) {
                JsonArray array = JsonUtils.func_151214_t((JsonObject)json, (String)"damage");
                if (array.size() > damage.length) {
                    throw new JsonParseException("Too many values for damage array: got " + array.size() + ", expected " + damage.length);
                }
                for (int i = 0; i < array.size(); ++i) {
                    JsonElement element = array.get(i);
                    if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
                        throw new JsonSyntaxException("Entry in damage array is not a number, got " + element);
                    }
                    damage[i] = element.getAsJsonPrimitive().getAsInt();
                }
            }
            return new DamageableShapelessOreRecipe(group.isEmpty() ? null : new ResourceLocation(group), damage, ings, itemstack);
        }
    }
}

