/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cubex2.cs4.api.ItemModule;
import cubex2.cs4.api.ItemModuleSupplier;
import cubex2.cs4.plugins.vanilla.ContentItemBase;
import cubex2.cs4.plugins.vanilla.gui.CapabilityItemHandlerSupplier;
import cubex2.cs4.plugins.vanilla.gui.ItemHandlerSupplier;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class CapabilityProviderItem
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound>,
ItemHandlerSupplier {
    private final ItemStack stack;
    private final ContentItemBase<?> content;
    private final LinkedHashMap<String, ItemModule> modules = Maps.newLinkedHashMap();

    public CapabilityProviderItem(ItemStack stack, ContentItemBase<?> content) {
        this.stack = stack;
        this.content = content;
        this.createModules();
    }

    private void createModules() {
        for (Map.Entry<String, ItemModuleSupplier> entry : this.content.modules.entrySet()) {
            this.modules.put(entry.getKey(), entry.getValue().createModule(this.stack));
        }
    }

    @Override
    public Optional<IItemHandler> getItemHandler(String name) {
        ItemModule module = this.modules.get(name);
        if (module != null) {
            return Optional.ofNullable(module.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        return Optional.empty();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandlerSupplier.ITEM_HANDLER_SUPPLIER_CAPABILITY) {
            return true;
        }
        return this.modules.values().stream().anyMatch(module -> module.hasCapability(capability, facing));
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandlerSupplier.ITEM_HANDLER_SUPPLIER_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.getItemHandlerCapability(facing);
        }
        for (ItemModule module : this.modules.values()) {
            if (!module.hasCapability(capability, facing)) continue;
            return module.getCapability(capability, facing);
        }
        return null;
    }

    @Nullable
    private IItemHandlerModifiable getItemHandlerCapability(@Nullable EnumFacing facing) {
        Capability capability = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        LinkedList handlers = Lists.newLinkedList();
        for (ItemModule module : this.modules.values()) {
            if (!module.hasCapability(capability, facing)) continue;
            handlers.add((IItemHandlerModifiable)module.getCapability(capability, facing));
        }
        if (handlers.size() == 1) {
            return (IItemHandlerModifiable)handlers.get(0);
        }
        if (handlers.size() > 1) {
            return new CombinedInvWrapper(handlers.toArray(new IItemHandlerModifiable[handlers.size()]));
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry<String, ItemModule> entry : this.modules.entrySet()) {
            ItemModule module = entry.getValue();
            NBTTagCompound moduleNbt = module.writeToNBT(new NBTTagCompound());
            nbt.func_74782_a("Module_" + entry.getKey(), (NBTBase)moduleNbt);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (Map.Entry<String, ItemModule> entry : this.modules.entrySet()) {
            NBTTagCompound moduleNbt = nbt.func_74775_l("Module_" + entry.getKey());
            ItemModule module = entry.getValue();
            module.readFromNBT(moduleNbt);
        }
    }
}

