/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.base.api.misc.IConfig;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.processor.ChunkLogger;
import pregenerator.impl.processor.ChunkProcessor;
import pregenerator.impl.retrogen.RetrogenHandler;

public class ConfigManager {
    static IConfig config;
    public static boolean shouldContinue;
    public static int playerDeactivation;
    public static int msPerTick;
    public static int skippingAmount;
    public static boolean tracking;
    public static boolean autoRestart;
    public static int restartMemory;
    public static int[] dimensionOrder;
    public static boolean orderOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createConfig(IConfig theConfig) {
        config = theConfig;
        try {
            ChunkProcessor pro = ChunkProcessor.INSTANCE;
            RetrogenHandler.INSTANCE.preInit(config);
            pro.setMaxTime(config.getInt("general", "TimePerTick", 10, Integer.MAX_VALUE, 40, "Storage for the TimePerTickCommand if needs to be changed outside of the game"));
            shouldContinue = config.getBoolean("general", "AutoStart", false, "Config for auto restart on World Load. Do not change unless you have to!");
            playerDeactivation = config.getInt("general", "PlayerLimit", -1, Integer.MAX_VALUE, -1, "Disables the Pregenerator when a certain playercount is reached. -1 disables it.");
            skippingAmount = config.getInt("general", "SkippingMarker", -1, "NEVER CHANGE THIS! Its a Marker for the SkipChunkCommand");
            tracking = config.getBoolean("general", "ServerTracking", false, "Enables that the Pregenerator does a bit of live profiling. Its not the best but it does things that others don't do");
            autoRestart = config.getBoolean("general", "autoRestart", FMLCommonHandler.instance().getSide().isServer(), "Auto Stops the game when the memory gets to low on average, ");
            restartMemory = config.getInt("general", "restartMemory", 1024, "How much free memory should be left until the stop kicks in");
            pro.setPriority(config.getBoolean("general", "PregenPriority", false, "Sets if the pregenerator should have the priority"));
            EnumSet<ChunkLogger> log = ChunkProcessor.INSTANCE.getLoggerInfo();
            List<ChunkLogger> loggers = ChunkLogger.getLoggers();
            for (ChunkLogger entry : loggers) {
                ConfigManager.addIfTrue(entry, log);
            }
            String dims = config.getString("preview", "Dimension Order", "0:-1:1", "Sets the order of the Preview Guis Dimension loading. Format: 0:1:-1");
            String[] values = dims.split(":");
            int[] dimensions = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                try {
                    dimensions[i] = Integer.parseInt(values[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dimensionOrder = dimensions;
            orderOnly = config.getBoolean("preview", "OrderOnly", false, "Instead of Collecting all of the Dimensions the Preview Gui will only allow the dimensions provided by 'Dimension Order'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            config.saveConfig();
        }
    }

    private static void addIfTrue(ChunkLogger type, EnumSet<ChunkLogger> log) {
        if (config.getBoolean("info", type.getName(), type.getDefault())) {
            log.add(type);
        }
    }

    public static List<Integer> getDimensions() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int id : dimensionOrder) {
            if (!BasePregenCommand.isDimensionValid(id)) continue;
            list.add(id);
        }
        return list;
    }

    public static void changeTracking(boolean result) {
        config.setBoolean("general", "ServerTracking", result);
        tracking = result;
    }

    public static void saveStart(boolean flag) {
        config.setBoolean("general", "AutoStart", flag);
        shouldContinue = flag;
    }

    public static void setPrority(boolean flag) {
        config.setBoolean("general", "PregenPriority", flag);
    }

    public static void setRestart(boolean flag) {
        config.setBoolean("general", "autoRestart", flag);
        autoRestart = flag;
    }

    public static void setRestartMemory(int memory) {
        config.setInt("general", "restartMemory", memory);
        restartMemory = memory;
    }

    public static void setPlayerCount(int count) {
        config.setInt("general", "PlayerLimit", count);
        playerDeactivation = count;
    }

    public static void saveTime(int time) {
        config.setInt("general", "TimePerTick", time);
    }

    public static void setSkipMarker(int amount) {
        skippingAmount = amount;
        config.setInt("general", "SkippingMarker", amount);
    }

    public static void saveType() {
        EnumSet<ChunkLogger> logging = ChunkProcessor.INSTANCE.getLoggerInfo();
        config.prepaireMassChange();
        for (ChunkLogger log : ChunkLogger.getLoggers()) {
            config.setBoolean("info", log.getName(), logging.contains((Object)log));
        }
        config.saveConfig();
    }

    public static void setBackupData(String value) {
        config.setString("general", "backupData", value);
    }

    public static String getBackupData() {
        return config.getString("general", "backupData", "", "DO NOT TOUCH THIS!!! UNLESS YOU WANT TO CORRUPT YOUR WORLD!!!");
    }

    static {
        msPerTick = 40;
        skippingAmount = -1;
        restartMemory = 1024;
        dimensionOrder = new int[0];
        orderOnly = false;
    }
}

