/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.OnTickMethod;
import yalter.mousetweaks.ScrollHandling;
import yalter.mousetweaks.WheelScrollDirection;
import yalter.mousetweaks.WheelSearchOrder;

public class Config {
    protected static final Properties defaultValues = new Properties();
    protected String fileName;
    public boolean rmbTweak = true;
    public boolean lmbTweakWithItem = true;
    public boolean lmbTweakWithoutItem = true;
    public boolean wheelTweak = true;
    public WheelSearchOrder wheelSearchOrder = WheelSearchOrder.LAST_TO_FIRST;
    public WheelScrollDirection wheelScrollDirection = WheelScrollDirection.NORMAL;
    public Set<OnTickMethod> onTickMethodOrder = new LinkedHashSet<OnTickMethod>();
    public ScrollHandling scrollHandling = ScrollHandling.SIMPLE;
    public static boolean debug = false;

    public Config(String fileName) {
        this.fileName = fileName;
    }

    public void read() {
        Properties properties = new Properties(defaultValues);
        try {
            FileReader configReader = new FileReader(this.fileName);
            properties.load(configReader);
            configReader.close();
        }
        catch (FileNotFoundException configReader) {
        }
        catch (IOException e) {
            Logger.Log("Failed to read the config file: " + this.fileName);
            e.printStackTrace();
        }
        this.rmbTweak = Config.parseIntOrDefault(properties.getProperty("RMBTweak"), 1) != 0;
        this.lmbTweakWithItem = Config.parseIntOrDefault(properties.getProperty("LMBTweakWithItem"), 1) != 0;
        this.lmbTweakWithoutItem = Config.parseIntOrDefault(properties.getProperty("LMBTweakWithoutItem"), 1) != 0;
        this.wheelTweak = Config.parseIntOrDefault(properties.getProperty("WheelTweak"), 1) != 0;
        this.wheelSearchOrder = WheelSearchOrder.fromId(Config.parseIntOrDefault(properties.getProperty("WheelSearchOrder"), 1));
        this.wheelScrollDirection = WheelScrollDirection.fromId(Config.parseIntOrDefault(properties.getProperty("WheelScrollDirection"), 0));
        this.onTickMethodOrderFromString(properties.getProperty("OnTickMethodOrder"));
        this.scrollHandling = ScrollHandling.fromId(Config.parseIntOrDefault(properties.getProperty("ScrollHandling"), 0));
        debug = Config.parseIntOrDefault(properties.getProperty("Debug"), 0) != 0;
    }

    private static int parseIntOrDefault(String s, int defaultValue) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void save() {
        try {
            File config = new File(this.fileName);
            boolean existed = config.exists();
            File parentDir = config.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            FileWriter configWriter = new FileWriter(config);
            Config.writeBoolean(configWriter, "RMBTweak", this.rmbTweak);
            Config.writeBoolean(configWriter, "LMBTweakWithItem", this.lmbTweakWithItem);
            Config.writeBoolean(configWriter, "LMBTweakWithoutItem", this.lmbTweakWithoutItem);
            Config.writeBoolean(configWriter, "WheelTweak", this.wheelTweak);
            Config.writeString(configWriter, "WheelSearchOrder", String.valueOf(this.wheelSearchOrder.ordinal()));
            Config.writeString(configWriter, "WheelScrollDirection", String.valueOf(this.wheelScrollDirection.ordinal()));
            Config.writeString(configWriter, "OnTickMethodOrder", this.onTickMethodOrderString());
            Config.writeString(configWriter, "ScrollHandling", String.valueOf(this.scrollHandling.ordinal()));
            Config.writeBoolean(configWriter, "Debug", debug);
            configWriter.close();
            if (!existed) {
                Logger.Log("Created the config file.");
            }
        }
        catch (IOException e) {
            Logger.Log("Failed to write the config file: " + this.fileName);
            e.printStackTrace();
        }
    }

    private static void writeString(FileWriter configWriter, String name, String value) throws IOException {
        configWriter.write(name + '=' + value + '\n');
    }

    private static void writeBoolean(FileWriter configWriter, String name, boolean value) throws IOException {
        Config.writeString(configWriter, name, value ? "1" : "0");
    }

    public String onTickMethodOrderString() {
        StringBuilder result = new StringBuilder();
        for (OnTickMethod method : this.onTickMethodOrder) {
            if (result.length() > 0) {
                result.append(", ");
            }
            switch (method) {
                case FORGE: {
                    result.append("Forge");
                    break;
                }
                case LITELOADER: {
                    result.append("LiteLoader");
                }
            }
        }
        return result.toString();
    }

    public void onTickMethodOrderFromString(String string) {
        String[] onTickMethods;
        this.onTickMethodOrder.clear();
        for (String method : onTickMethods = string.trim().split("[\\s]*,[\\s]*")) {
            if ("Forge".equalsIgnoreCase(method)) {
                this.onTickMethodOrder.add(OnTickMethod.FORGE);
                continue;
            }
            if (!"LiteLoader".equalsIgnoreCase(method)) continue;
            this.onTickMethodOrder.add(OnTickMethod.LITELOADER);
        }
        this.onTickMethodOrder.add(OnTickMethod.FORGE);
        this.onTickMethodOrder.add(OnTickMethod.LITELOADER);
    }

    static {
        defaultValues.setProperty("RMBTweak", "1");
        defaultValues.setProperty("LMBTweakWithItem", "1");
        defaultValues.setProperty("LMBTweakWithoutItem", "1");
        defaultValues.setProperty("WheelTweak", "1");
        defaultValues.setProperty("WheelSearchOrder", "1");
        defaultValues.setProperty("WheelScrollDirection", "0");
        defaultValues.setProperty("OnTickMethodOrder", "Forge, LiteLoader");
        defaultValues.setProperty("ScrollHandling", "0");
        defaultValues.setProperty("Debug", "0");
    }
}

