/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.helper;

import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreCrusherRecipe {
    public static final String TAG_ITEMSTACK_INPUT = "itemStackInput";
    public static final String TAG_ORE_DICT_INPUT = "oreDictInput";
    public static final String TAG_ITEMSTACK_OUTPUT = "itemStackOutput";
    public static final OreCrusherRecipe EMPTY = new OreCrusherRecipe();
    private ItemStack itemStackInput = ItemStack.field_190927_a;
    private ItemStack itemStackOutput = ItemStack.field_190927_a;
    private String oreDictInput;

    public OreCrusherRecipe() {
    }

    public OreCrusherRecipe(ItemStack itemStackInput, ItemStack itemStackOutput) {
        this.itemStackInput = itemStackInput;
        this.itemStackOutput = itemStackOutput;
    }

    public OreCrusherRecipe(String oreDictInput, ItemStack itemStackOutput) {
        this.oreDictInput = oreDictInput;
        this.itemStackOutput = itemStackOutput;
    }

    public boolean match(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        if (!this.itemStackInput.func_190926_b() && itemStack.func_77969_a(this.itemStackInput)) {
            return true;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)itemStack);
        if (ids.length > 0) {
            String oreName = OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)itemStack)[0]);
            return oreName.equals(this.oreDictInput);
        }
        return false;
    }

    public ItemStack getItemStackOutput() {
        return this.itemStackOutput;
    }

    public boolean isEmpty() {
        return this.itemStackInput.func_190926_b() && this.oreDictInput == null || this.itemStackOutput.func_190926_b();
    }

    public ItemStack getItemStackInput() {
        return this.itemStackInput;
    }

    public String getOreDictInput() {
        return this.oreDictInput;
    }

    public OreCrusherRecipe copy() {
        if (this.oreDictInput != null) {
            return new OreCrusherRecipe(this.oreDictInput, this.itemStackOutput);
        }
        if (!this.itemStackInput.func_190926_b()) {
            return new OreCrusherRecipe(this.itemStackInput, this.itemStackOutput);
        }
        return EMPTY;
    }
}

