/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.plugins.jei.fuelInputMachine;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import tinker_io.registry.BlockRegistry;
import tinker_io.registry.ItemRegistry;

public class FuelInputMachineRecipeCategory
implements IRecipeCategory {
    public static String CATEGORY = "tinker_io:fuel_input_machine";
    private static ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("tinker_io", "textures/gui/jei/fuel_input_machine_jei_recipe.png");
    protected final IDrawable background;
    protected final IDrawableAnimated arrow;

    public FuelInputMachineRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUND_TEXTURE, 0, 0, 140, 60);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(BACKGROUND_TEXTURE, 142, 23, 14, 14);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 100, IDrawableAnimated.StartDirection.TOP, true);
    }

    public String getUid() {
        return CATEGORY;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)(BlockRegistry.fuelInputMachine.func_149739_a() + ".name"), (Object[])new Object[0]);
    }

    public String getModName() {
        return "Tinker I/O";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 81, 24);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup items = recipeLayout.getItemStacks();
        items.init(0, true, 57, 22);
        items.set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        LinkedList speedUpg = Lists.newLinkedList();
        speedUpg.add(new ItemStack((Item)ItemRegistry.speedUpgrade));
        items.init(2, false, 3, 22);
        items.set(2, (List)speedUpg);
    }
}

