/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock;

import javax.annotation.Nullable;
import nc.block.tile.IActivatable;
import nc.capability.radiation.source.IRadiationSource;
import nc.capability.radiation.source.RadiationSource;
import nc.tile.ITile;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileBeefBase
extends TileEntity
implements ITile,
ITickable {
    public boolean isAdded = false;
    public boolean isMarkedDirty = false;
    private boolean isRedstonePowered = false;
    private boolean alternateComparator = false;
    private boolean redstoneControl = false;
    private IRadiationSource radiation = new RadiationSource(0.0);

    public void func_73660_a() {
        if (!this.isAdded) {
            this.onAdded();
            this.isAdded = true;
        }
        if (this.isMarkedDirty) {
            this.func_70296_d();
            this.isMarkedDirty = false;
        }
    }

    public void onAdded() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.field_145850_b.func_175726_f(this.field_174879_c).func_76630_e();
            this.refreshIsRedstonePowered(this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
        }
    }

    @Override
    public World getTileWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getTilePos() {
        return this.field_174879_c;
    }

    @Override
    public Block getTileBlockType() {
        return this.func_145838_q();
    }

    @Override
    public int getTileBlockMeta() {
        return this.func_145832_p();
    }

    @Override
    public IRadiationSource getRadiationSource() {
        return this.radiation;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        BlockPos position = this.field_174879_c;
        if (this.field_145850_b.func_175625_s(position) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void setState(boolean isActive, TileEntity tile) {
        if (this.func_145838_q() instanceof IActivatable) {
            ((IActivatable)this.func_145838_q()).setState(isActive, tile);
        }
    }

    @Override
    public void markDirtyAndNotify() {
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
    }

    @Override
    public void markTileDirty() {
        this.func_70296_d();
    }

    @Override
    public boolean getIsRedstonePowered() {
        return this.isRedstonePowered;
    }

    @Override
    public void setIsRedstonePowered(boolean isRedstonePowered) {
        this.isRedstonePowered = isRedstonePowered;
    }

    @Override
    public boolean getAlternateComparator() {
        return this.alternateComparator;
    }

    @Override
    public void setAlternateComparator(boolean alternate) {
        this.alternateComparator = alternate;
    }

    @Override
    public boolean getRedstoneControl() {
        return this.redstoneControl;
    }

    @Override
    public void setRedstoneControl(boolean redstoneControl) {
        this.redstoneControl = redstoneControl;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return this.radiation != null;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return (T)this.radiation;
        }
        return (T)super.getCapability(capability, side);
    }

    public boolean canOpenGui(World world, BlockPos posistion, IBlockState state) {
        return false;
    }

    public boolean openGui(Object mod, EntityPlayer player, int guiId) {
        player.openGui(mod, guiId, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        return true;
    }

    public Object getServerGuiElement(int guiId, EntityPlayer player) {
        return null;
    }

    public Object getClientGuiElement(int guiId, EntityPlayer player) {
        return null;
    }

    public void readRadiation(NBTTagCompound data) {
        if (data.func_74764_b("radiationLevel")) {
            this.getRadiationSource().setRadiationLevel(data.func_74769_h("radiationLevel"));
        }
    }

    public NBTTagCompound writeRadiation(NBTTagCompound data) {
        data.func_74780_a("radiationLevel", this.getRadiationSource().getRadiationLevel());
        return data;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.syncDataTo(super.func_189515_b(data), SyncReason.FullSync);
        this.writeAll(data);
        return data;
    }

    public NBTTagCompound writeAll(NBTTagCompound data) {
        data.func_74757_a("isRedstonePowered", this.isRedstonePowered);
        data.func_74757_a("alternateComparator", this.alternateComparator);
        data.func_74757_a("redstoneControl", this.redstoneControl);
        if (this.shouldSaveRadiation()) {
            this.writeRadiation(data);
        }
        return data;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.syncDataFrom(data, SyncReason.FullSync);
        this.readAll(data);
    }

    public void readAll(NBTTagCompound data) {
        this.isRedstonePowered = data.func_74767_n("isRedstonePowered");
        this.alternateComparator = data.func_74767_n("alternateComparator");
        this.redstoneControl = data.func_74767_n("redstoneControl");
        if (this.shouldSaveRadiation()) {
            this.readRadiation(data);
        }
    }

    public void handleUpdateTag(NBTTagCompound data) {
        super.handleUpdateTag(data);
        this.syncDataFrom(data, SyncReason.NetworkUpdate);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound data = super.func_189517_E_();
        this.writeAll(data);
        this.syncDataTo(data, SyncReason.NetworkUpdate);
        return data;
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readAll(packet.func_148857_g());
        this.syncDataFrom(packet.func_148857_g(), SyncReason.NetworkUpdate);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound data = new NBTTagCompound();
        this.writeAll(data);
        int metadata = this.func_145832_p();
        this.syncDataTo(data, SyncReason.NetworkUpdate);
        return new SPacketUpdateTileEntity(this.field_174879_c, metadata, data);
    }

    protected abstract void syncDataFrom(NBTTagCompound var1, SyncReason var2);

    protected abstract void syncDataTo(NBTTagCompound var1, SyncReason var2);

    public static enum SyncReason {
        FullSync,
        NetworkUpdate;

    }
}

