/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.util.ImpostorRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.module.IModuleHandler;
import org.squiddev.plethora.api.module.IModuleRegistry;
import org.squiddev.plethora.api.vehicle.IVehicleUpgradeHandler;
import org.squiddev.plethora.core.PocketUpgradeModule;
import org.squiddev.plethora.core.TurtleUpgradeModule;
import org.squiddev.plethora.core.VehicleUpgradeModule;

final class ModuleRegistry
implements IModuleRegistry {
    public static final ModuleRegistry instance = new ModuleRegistry();
    private final List<IPocketUpgrade> pocketUpgrades = new ArrayList<IPocketUpgrade>();
    private final List<ITurtleUpgrade> turtleUpgrades = new ArrayList<ITurtleUpgrade>();

    private ModuleRegistry() {
    }

    @Override
    public void registerTurtleUpgrade(@Nonnull ItemStack stack) {
        Objects.requireNonNull(stack, "stack cannot be null");
        this.registerTurtleUpgrade(stack, stack.func_77977_a() + ".adjective");
    }

    @Override
    public void registerTurtleUpgrade(@Nonnull ItemStack stack, @Nonnull String adjective) {
        Objects.requireNonNull(stack, "stack cannot be null");
        Objects.requireNonNull(adjective, "adjective cannot be null");
        IModuleHandler handler = (IModuleHandler)stack.getCapability(Constants.MODULE_HANDLER_CAPABILITY, null);
        if (handler == null) {
            throw new NullPointerException("stack has no handler");
        }
        this.registerTurtleUpgrade(stack, handler, adjective);
    }

    @Override
    public void registerTurtleUpgrade(@Nonnull ItemStack stack, @Nonnull IModuleHandler handler, @Nonnull String adjective) {
        Objects.requireNonNull(stack, "stack cannot be null");
        Objects.requireNonNull(stack, "handler cannot be null");
        Objects.requireNonNull(adjective, "adjective cannot be null");
        TurtleUpgradeModule upgrade = new TurtleUpgradeModule(stack, handler, adjective);
        ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)upgrade);
        this.turtleUpgrades.add(upgrade);
    }

    @Override
    public void registerPocketUpgrade(@Nonnull ItemStack stack) {
        Objects.requireNonNull(stack, "stack cannot be null");
        this.registerPocketUpgrade(stack, stack.func_77977_a() + ".adjective");
    }

    @Override
    public void registerPocketUpgrade(@Nonnull ItemStack stack, @Nonnull String adjective) {
        Objects.requireNonNull(stack, "stack cannot be null");
        Objects.requireNonNull(adjective, "adjective cannot be null");
        IModuleHandler handler = (IModuleHandler)stack.getCapability(Constants.MODULE_HANDLER_CAPABILITY, null);
        if (handler == null) {
            throw new NullPointerException("stack has no handler");
        }
        this.registerPocketUpgrade(stack, handler, adjective);
    }

    @Override
    public void registerPocketUpgrade(@Nonnull ItemStack stack, @Nonnull IModuleHandler handler, @Nonnull String adjective) {
        Objects.requireNonNull(stack, "stack cannot be null");
        Objects.requireNonNull(stack, "handler cannot be null");
        Objects.requireNonNull(adjective, "adjective cannot be null");
        PocketUpgradeModule upgrade = new PocketUpgradeModule(stack, handler, adjective);
        ComputerCraftAPI.registerPocketUpgrade((IPocketUpgrade)upgrade);
        this.pocketUpgrades.add(upgrade);
    }

    @Override
    public IVehicleUpgradeHandler toVehicleUpgrade(@Nonnull IModuleHandler handler) {
        Objects.requireNonNull(handler, "handler cannot be null");
        return new VehicleUpgradeModule(handler);
    }

    void addRecipes(IForgeRegistry<IRecipe> registry) {
        for (ITurtleUpgrade iTurtleUpgrade : this.turtleUpgrades) {
            registry.register(new ImpostorRecipe("plethora-core:turtle_upgrade", 2, 1, new ItemStack[]{iTurtleUpgrade.getCraftingItem(), TurtleItemFactory.create((int)-1, null, (int)-1, (ComputerFamily)ComputerFamily.Normal, null, null, (int)-1, null)}, TurtleItemFactory.create((int)-1, null, (int)-1, (ComputerFamily)ComputerFamily.Normal, null, (ITurtleUpgrade)iTurtleUpgrade, (int)-1, null)).setRegistryName(new ResourceLocation("plethora-core", "turtle_" + iTurtleUpgrade.getUpgradeID().toString().replace(':', '_'))));
        }
        for (IPocketUpgrade iPocketUpgrade : this.pocketUpgrades) {
            registry.register(new ImpostorRecipe("plethora-core:pocket_upgrade", 1, 2, new ItemStack[]{iPocketUpgrade.getCraftingItem(), PocketComputerItemFactory.create((int)-1, null, (int)-1, (ComputerFamily)ComputerFamily.Normal, null)}, PocketComputerItemFactory.create((int)-1, null, (int)-1, (ComputerFamily)ComputerFamily.Normal, (IPocketUpgrade)iPocketUpgrade)).setRegistryName(new ResourceLocation("plethora-core", "pocket_" + iPocketUpgrade.getUpgradeID().toString().replace(':', '_'))));
        }
    }
}

