/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.neural;

import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;
import org.squiddev.plethora.gameplay.neural.ItemComputerHandler;
import org.squiddev.plethora.gameplay.neural.NeuralHelpers;
import org.squiddev.plethora.gameplay.neural.NeuralItemHandler;
import org.squiddev.plethora.utils.Vec2i;

public class ContainerNeuralInterface
extends Container
implements IContainerComputer {
    public static final int START_Y = 134;
    private static final int MAIN_START_X = 8;
    public static final int NEURAL_START_X = 185;
    public static final int S = 18;
    public static final Vec2i[] POSITIONS = new Vec2i[]{new Vec2i(204, 171), new Vec2i(204, 135), new Vec2i(204, 153), new Vec2i(222, 153), new Vec2i(186, 153)};
    public static final Vec2i SWAP = new Vec2i(222, 171);
    private final ItemStack stack;
    private final EntityLivingBase parent;
    public final Slot[] peripheralSlots;
    public final Slot[] moduleSlots;

    public ContainerNeuralInterface(IInventory playerInventory, EntityLivingBase parent, ItemStack stack) {
        this.stack = stack;
        this.parent = parent;
        NeuralItemHandler stackInv = (NeuralItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.peripheralSlots = this.addSlots(stackInv, 0, 5);
        this.moduleSlots = this.addSlots(stackInv, 5, 5);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(playerInventory, x + y * 9 + 9, 8 + x * 18, 135 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot(playerInventory, x, 8 + x * 18, 193));
        }
    }

    private Slot[] addSlots(NeuralItemHandler stackInv, int offset, int length) {
        Slot[] slots = new Slot[length];
        for (int i = 0; i < length; ++i) {
            slots[i] = new NeuralSlot(stackInv, offset + i, 0, 0);
            this.func_75146_a(slots[i]);
        }
        return slots;
    }

    public boolean func_75145_c(@Nullable EntityPlayer player) {
        return player != null && player.func_70089_S() && this.parent.func_70089_S() && this.stack == NeuralHelpers.getStack(this.parent);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotIdx) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIdx);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (slotIdx < 10 ? !this.func_75135_a(slotStack, 10, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, 10, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        int i;
        boolean flag = false;
        int n = i = reverseDirection ? endIndex - 1 : startIndex;
        while (stack.func_190916_E() > 0 && (reverseDirection ? i >= startIndex : i < endIndex)) {
            boolean reachedLimit;
            Slot slot = (Slot)this.field_75151_b.get(i);
            ItemStack existing = slot.func_75211_c();
            i += reverseDirection ? -1 : 1;
            if (!slot.func_75214_a(stack)) continue;
            int limit = slot.func_178170_b(stack);
            if (!existing.func_190926_b()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) continue;
                limit -= existing.func_190916_E();
            }
            if (limit <= 0) continue;
            boolean bl = reachedLimit = stack.func_190916_E() > limit;
            if (existing.func_190926_b()) {
                slot.func_75215_d(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack.func_77946_l());
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            slot.func_75218_e();
            stack.func_190920_e(reachedLimit ? stack.func_190916_E() - limit : 0);
            flag = true;
        }
        return flag;
    }

    @Nullable
    public IComputer getComputer() {
        return ItemComputerHandler.tryGetServer(this.stack);
    }

    private static final class NeuralSlot
    extends SlotItemHandler {
        private final int index;
        private final NeuralItemHandler handler;

        NeuralSlot(NeuralItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)itemHandler, index, xPosition, yPosition);
            this.index = index;
            this.handler = itemHandler;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return !stack.func_190926_b() && this.handler.isItemValid(this.index, stack);
        }
    }
}

