/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.recipe.advanced;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import wanion.lib.recipe.advanced.IAdvancedRecipe;

public abstract class AbstractShapelessAdvancedRecipe
implements IAdvancedRecipe {
    public final List<Object> inputs;
    private final ItemStack output;
    private final short recipeSize;

    public AbstractShapelessAdvancedRecipe(@Nonnull ItemStack output, Object ... inputs) {
        this.output = output.func_77946_l();
        short recipeSize = 0;
        ArrayList<Object> temporaryInputs = new ArrayList<Object>();
        for (Object input : inputs) {
            if (input instanceof ItemStack) {
                if (((ItemStack)input).func_190926_b()) continue;
                ItemStack newInput = ((ItemStack)input).func_77946_l();
                newInput.func_190920_e(1);
                temporaryInputs.add(newInput);
            } else if (input instanceof String) {
                NonNullList oreList = OreDictionary.getOres((String)((String)input), (boolean)false);
                if (oreList == null || oreList.isEmpty()) continue;
                temporaryInputs.add(oreList);
            } else {
                if (!(input instanceof List) || ((List)input).isEmpty() || !(((List)input).get(0) instanceof ItemStack)) continue;
                temporaryInputs.add(input);
            }
            recipeSize = (short)(recipeSize + 1);
        }
        if (recipeSize == 0 || recipeSize > this.getMaxRecipeSize()) {
            throw new RuntimeException("Invalid " + this.getRecipeType());
        }
        this.recipeSize = recipeSize;
        this.inputs = NonNullList.func_191197_a((int)this.recipeSize, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < temporaryInputs.size(); ++i) {
            this.inputs.set(i, temporaryInputs.get(i));
        }
    }

    public abstract String getRecipeType();

    public abstract short getMaxRecipeSize();

    @Override
    public boolean isShaped() {
        return false;
    }

    @Override
    public short getRecipeKey() {
        return this.recipeSize;
    }

    @Override
    public short getRecipeSize() {
        return this.recipeSize;
    }

    @Override
    public int getWidth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return 0;
    }

    @Override
    @Nonnull
    public List<Object> getInputs() {
        return this.inputs;
    }

    @Override
    @Nonnull
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public boolean recipeMatches(@Nonnull InventoryCrafting inventoryCrafting, int offSetX, int offSetY) {
        ArrayList<Object> inputs = new ArrayList<Object>(this.inputs);
        ArrayList<ItemStack> slotItemStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inventoryCrafting.func_70302_i_(); ++i) {
            ItemStack slotItemStack = inventoryCrafting.func_70301_a(i);
            if (slotItemStack.func_190926_b()) continue;
            slotItemStacks.add(slotItemStack);
        }
        Iterator inputsIterator = inputs.iterator();
        while (inputsIterator.hasNext()) {
            Object input = inputsIterator.next();
            boolean found = false;
            if (input instanceof ItemStack) {
                Iterator slotItemStackIterator = slotItemStacks.iterator();
                while (slotItemStackIterator.hasNext()) {
                    ItemStack slotItemStack = (ItemStack)slotItemStackIterator.next();
                    if (slotItemStack.func_77973_b() != ((ItemStack)input).func_77973_b() || ((ItemStack)input).func_77981_g() && ((ItemStack)input).func_77952_i() != slotItemStack.func_77952_i() || !ItemStack.func_77970_a((ItemStack)((ItemStack)input), (ItemStack)slotItemStack)) continue;
                    slotItemStackIterator.remove();
                    found = true;
                    break;
                }
            } else if (input instanceof List) {
                List oreDict = (List)input;
                for (ItemStack entry : oreDict) {
                    Iterator slotItemStackIterator = slotItemStacks.iterator();
                    while (slotItemStackIterator.hasNext()) {
                        ItemStack slotItemStack = (ItemStack)slotItemStackIterator.next();
                        if (entry.func_77973_b() != slotItemStack.func_77973_b() || entry.func_77952_i() != slotItemStack.func_77952_i() && entry.func_77952_i() != Short.MAX_VALUE) continue;
                        slotItemStackIterator.remove();
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
            }
            if (!found) continue;
            inputsIterator.remove();
        }
        return inputs.isEmpty() && slotItemStacks.isEmpty();
    }
}

