/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import net.minecraft.util.ResourceLocation;
import openblocks.common.container.ContainerDrawingTable;
import openblocks.common.tileentity.TileEntityDrawingTable;
import openblocks.rpc.IStencilCrafter;
import openmods.api.IValueProvider;
import openmods.api.IValueReceiver;
import openmods.container.ContainerBase;
import openmods.gui.Icon;
import openmods.gui.SyncedGuiContainer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentIconButton;
import openmods.gui.component.GuiComponentSprite;
import openmods.gui.component.GuiComponentTextButton;
import openmods.gui.component.GuiComponentTextbox;
import openmods.gui.logic.IValueUpdateAction;
import openmods.gui.logic.ValueCopyAction;
import openmods.utils.TranslationUtils;

public class GuiDrawingTable
extends SyncedGuiContainer<ContainerDrawingTable> {
    private static final Icon ARROW_LEFT = Icon.createSheetIcon((ResourceLocation)BaseComponent.WIDGETS, (int)0, (int)82, (int)16, (int)16);
    private static final Icon ARROW_UP = Icon.createSheetIcon((ResourceLocation)BaseComponent.WIDGETS, (int)16, (int)82, (int)16, (int)16);

    public GuiDrawingTable(ContainerDrawingTable container) {
        super((ContainerBase)container, 176, 204, "openblocks.gui.drawingtable");
        IStencilCrafter rpcProxy = (IStencilCrafter)((TileEntityDrawingTable)((ContainerDrawingTable)this.getContainer()).getOwner()).createClientRpcProxy(IStencilCrafter.class, new Class[0]);
        TileEntityDrawingTable owner = (TileEntityDrawingTable)container.getOwner();
        IValueProvider<IStencilCrafter.Mode> mode = owner.getMode();
        IValueProvider<String> text = owner.getTextToPrint();
        GuiComponentTextButton modeSelection = new GuiComponentTextButton(8, 35, 50, 14, 0xFFFFFF, IStencilCrafter.Mode.STENCILS.getTranslatedName());
        modeSelection.setListener((component, x, y, button) -> rpcProxy.cycleMode());
        int buttonHeight = GuiDrawingTable.ARROW_UP.height + 4;
        GuiComponentIconButton buttonTop = new GuiComponentIconButton(116, 43 - buttonHeight, 0xFFFFFF, ARROW_UP);
        buttonTop.setListener((component, x, y, button) -> rpcProxy.selectionUp());
        GuiComponentIconButton buttonBottom = new GuiComponentIconButton(116, 43, 0xFFFFFF, ARROW_UP.mirrorHorizontal());
        buttonBottom.setListener((component, x, y, button) -> rpcProxy.selectionDown());
        GuiComponentTextbox textToPrint = new GuiComponentTextbox(8, 90, 120, 14);
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(text, (IValueReceiver)textToPrint));
        GuiComponentTextButton print = new GuiComponentTextButton(130, 90, 40, 14, 0xFFFFFF, TranslationUtils.translateToLocal((String)"openblocks.gui.drawingtable.print"));
        print.setListener((component, x, y, button) -> rpcProxy.printGlyphs(textToPrint.getText()));
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(mode, newMode -> {
            modeSelection.setText(newMode.getTranslatedName());
            boolean enablePrint = newMode == IStencilCrafter.Mode.GLYPHS;
            textToPrint.setEnabled(enablePrint);
            print.setEnabled(enablePrint);
        }));
        this.root.addComponent((BaseComponent)new GuiComponentSprite(80, 34, ARROW_LEFT.mirrorVertical()));
        this.root.addComponent((BaseComponent)buttonTop);
        this.root.addComponent((BaseComponent)buttonBottom);
        this.root.addComponent((BaseComponent)modeSelection);
        this.root.addComponent((BaseComponent)textToPrint);
        this.root.addComponent((BaseComponent)print);
    }
}

