/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.ToolsConfig;
import mekanism.tools.common.ToolsCommonProxy;
import mekanism.tools.common.ToolsItems;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="mekanismtools", useMetadata=true, guiFactory="mekanism.tools.client.gui.ToolsGuiFactory", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class MekanismTools
implements IModule {
    public static final String MODID = "mekanismtools";
    @SidedProxy(clientSide="mekanism.tools.client.ToolsClientProxy", serverSide="mekanism.tools.common.ToolsCommonProxy")
    public static ToolsCommonProxy proxy;
    @Mod.Instance(value="mekanismtools")
    public static MekanismTools instance;
    public static Version versionNumber;
    public static Item.ToolMaterial toolOBSIDIAN;
    public static Item.ToolMaterial toolOBSIDIAN2;
    public static Item.ToolMaterial toolLAZULI;
    public static Item.ToolMaterial toolLAZULI2;
    public static Item.ToolMaterial toolOSMIUM;
    public static Item.ToolMaterial toolOSMIUM2;
    public static Item.ToolMaterial toolBRONZE;
    public static Item.ToolMaterial toolBRONZE2;
    public static Item.ToolMaterial toolGLOWSTONE;
    public static Item.ToolMaterial toolGLOWSTONE2;
    public static Item.ToolMaterial toolSTEEL;
    public static Item.ToolMaterial toolSTEEL2;
    public static ItemArmor.ArmorMaterial armorOBSIDIAN;
    public static ItemArmor.ArmorMaterial armorLAZULI;
    public static ItemArmor.ArmorMaterial armorOSMIUM;
    public static ItemArmor.ArmorMaterial armorBRONZE;
    public static ItemArmor.ArmorMaterial armorGLOWSTONE;
    public static ItemArmor.ArmorMaterial armorSTEEL;
    public static Map<Item.ToolMaterial, Float> AXE_DAMAGE;
    public static Map<Item.ToolMaterial, Float> AXE_SPEED;

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ToolsItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        proxy.registerItemRenders();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.loadConfiguration();
        this.addItems();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Mekanism.modulesLoaded.add(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Mekanism.logger.info("Loaded 'Mekanism: Tools' module.");
    }

    public void addItems() {
        toolOBSIDIAN = this.getToolMaterial("OBSIDIAN", MekanismConfig.current().tools.toolOBSIDIAN);
        toolOBSIDIAN2 = this.getToolMaterial("OBSIDIAN2", MekanismConfig.current().tools.toolOBSIDIAN2);
        toolLAZULI = this.getToolMaterial("LAZULI", MekanismConfig.current().tools.toolLAZULI);
        toolLAZULI2 = this.getToolMaterial("LAZULI2", MekanismConfig.current().tools.toolLAZULI2);
        toolOSMIUM = this.getToolMaterial("OSMIUM", MekanismConfig.current().tools.toolOSMIUM);
        toolOSMIUM2 = this.getToolMaterial("OSMIUM2", MekanismConfig.current().tools.toolOSMIUM2);
        toolBRONZE = this.getToolMaterial("BRONZE", MekanismConfig.current().tools.toolBRONZE);
        toolBRONZE2 = this.getToolMaterial("BRONZE2", MekanismConfig.current().tools.toolBRONZE2);
        toolGLOWSTONE = this.getToolMaterial("GLOWSTONE", MekanismConfig.current().tools.toolGLOWSTONE);
        toolGLOWSTONE2 = this.getToolMaterial("GLOWSTONE2", MekanismConfig.current().tools.toolGLOWSTONE2);
        toolSTEEL = this.getToolMaterial("STEEL", MekanismConfig.current().tools.toolSTEEL);
        toolSTEEL2 = this.getToolMaterial("STEEL2", MekanismConfig.current().tools.toolSTEEL2);
        this.setAxeSpeedDamage(toolOBSIDIAN, MekanismConfig.current().tools.toolOBSIDIAN);
        this.setAxeSpeedDamage(toolLAZULI, MekanismConfig.current().tools.toolLAZULI);
        this.setAxeSpeedDamage(toolOSMIUM, MekanismConfig.current().tools.toolOSMIUM);
        this.setAxeSpeedDamage(toolBRONZE, MekanismConfig.current().tools.toolBRONZE);
        this.setAxeSpeedDamage(toolGLOWSTONE, MekanismConfig.current().tools.toolGLOWSTONE);
        this.setAxeSpeedDamage(toolSTEEL, MekanismConfig.current().tools.toolSTEEL);
        armorOBSIDIAN = this.getArmorMaterial("OBSIDIAN", MekanismConfig.current().tools.armorOBSIDIAN, SoundEvents.field_187725_r);
        armorLAZULI = this.getArmorMaterial("LAZULI", MekanismConfig.current().tools.armorLAZULI, SoundEvents.field_187716_o);
        armorOSMIUM = this.getArmorMaterial("OSMIUM", MekanismConfig.current().tools.armorOSMIUM, SoundEvents.field_187725_r);
        armorBRONZE = this.getArmorMaterial("BRONZE", MekanismConfig.current().tools.armorBRONZE, SoundEvents.field_187725_r);
        armorGLOWSTONE = this.getArmorMaterial("GLOWSTONE", MekanismConfig.current().tools.armorGLOWSTONE, SoundEvents.field_187725_r);
        armorSTEEL = this.getArmorMaterial("STEEL", MekanismConfig.current().tools.armorSTEEL, SoundEvents.field_187725_r);
        ToolsItems.initializeItems();
        ToolsItems.setHarvestLevels();
    }

    private void setAxeSpeedDamage(Item.ToolMaterial toolOBSIDIAN, ToolsConfig.ToolBalance toolOBSIDIAN2) {
        AXE_DAMAGE.put(toolOBSIDIAN, Float.valueOf(toolOBSIDIAN2.axeAttackDamage.val()));
        AXE_SPEED.put(toolOBSIDIAN, Float.valueOf(toolOBSIDIAN2.axeAttackSpeed.val()));
    }

    private Item.ToolMaterial getToolMaterial(String enumName, ToolsConfig.ToolBalance toolConfig) {
        return EnumHelper.addToolMaterial((String)enumName, (int)toolConfig.harvestLevel.val(), (int)toolConfig.maxUses.val(), (float)toolConfig.efficiency.val(), (float)toolConfig.damage.val(), (int)toolConfig.enchantability.val());
    }

    private ItemArmor.ArmorMaterial getArmorMaterial(String enumName, ToolsConfig.ArmorBalance settings, SoundEvent equipSoundEvent) {
        return EnumHelper.addArmorMaterial((String)enumName, (String)"TODO", (int)settings.durability.val(), (int[])new int[]{settings.feetProtection.val(), settings.legsProtection.val(), settings.chestProtection.val(), settings.headProtection.val()}, (int)settings.enchantability.val(), (SoundEvent)equipSoundEvent, (float)settings.toughness.val());
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        GameRegistry.addSmelting((Item)ToolsItems.IronPaxel, (ItemStack)new ItemStack(Items.field_191525_da), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.GoldPaxel, (ItemStack)new ItemStack(Items.field_151074_bl), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.GlowstonePaxel, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 3), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.GlowstonePickaxe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 3), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.GlowstoneAxe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 3), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.GlowstoneShovel, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 3), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.GlowstoneHoe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 3), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.GlowstoneSword, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 3), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.GlowstoneHelmet, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 3), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.GlowstoneChestplate, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 3), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.GlowstoneLeggings, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 3), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.GlowstoneBoots, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 3), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.BronzePaxel, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.BronzePickaxe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.BronzeAxe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.BronzeShovel, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.BronzeHoe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.BronzeSword, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.BronzeHelmet, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.BronzeChestplate, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.BronzeLeggings, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.BronzeBoots, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.OsmiumPaxel, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.OsmiumPickaxe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.OsmiumAxe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.OsmiumShovel, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.OsmiumHoe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.OsmiumSword, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.OsmiumHelmet, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.OsmiumChestplate, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.OsmiumLeggings, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.OsmiumBoots, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 1), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.ObsidianPaxel, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.ObsidianPickaxe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.ObsidianAxe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.ObsidianShovel, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.ObsidianHoe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.ObsidianSword, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.ObsidianHelmet, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.ObsidianChestplate, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.ObsidianLeggings, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.ObsidianBoots, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.SteelPaxel, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.SteelPickaxe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.SteelAxe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.SteelShovel, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.SteelHoe, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.SteelSword, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.SteelHelmet, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.SteelChestplate, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.SteelLeggings, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((Item)ToolsItems.SteelBoots, (ItemStack)new ItemStack(MekanismItems.Nugget, 1, 4), (float)0.1f);
    }

    private void setStackIfEmpty(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack item) {
        if (entity.func_184582_a(slot).func_190926_b()) {
            entity.func_184201_a(slot, item);
        }
    }

    private void setEntityArmorWithChance(Random random, EntityLivingBase entity, Item sword, Item helmet, Item chestplate, Item leggings, Item boots) {
        if (entity instanceof EntityZombie && random.nextInt(100) < 50) {
            this.setStackIfEmpty(entity, EntityEquipmentSlot.MAINHAND, new ItemStack(sword));
        }
        if (random.nextInt(100) < 50) {
            this.setStackIfEmpty(entity, EntityEquipmentSlot.HEAD, new ItemStack(helmet));
        }
        if (random.nextInt(100) < 50) {
            this.setStackIfEmpty(entity, EntityEquipmentSlot.CHEST, new ItemStack(chestplate));
        }
        if (random.nextInt(100) < 50) {
            this.setStackIfEmpty(entity, EntityEquipmentSlot.LEGS, new ItemStack(leggings));
        }
        if (random.nextInt(100) < 50) {
            this.setStackIfEmpty(entity, EntityEquipmentSlot.FEET, new ItemStack(boots));
        }
    }

    @SubscribeEvent
    public void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Random random = event.getWorld().field_73012_v;
        double chance = random.nextDouble();
        if (chance < MekanismConfig.current().tools.armorSpawnRate.val()) {
            int armorType = random.nextInt(4);
            EntityLivingBase entity = event.getEntityLiving();
            if (entity instanceof EntityZombie || entity instanceof EntitySkeleton) {
                if (armorType == 0) {
                    this.setEntityArmorWithChance(random, entity, ToolsItems.GlowstoneSword, ToolsItems.GlowstoneHelmet, ToolsItems.GlowstoneChestplate, ToolsItems.GlowstoneLeggings, ToolsItems.GlowstoneBoots);
                } else if (armorType == 1) {
                    this.setEntityArmorWithChance(random, entity, ToolsItems.LazuliSword, ToolsItems.LazuliHelmet, ToolsItems.LazuliChestplate, ToolsItems.LazuliLeggings, ToolsItems.LazuliBoots);
                } else if (armorType == 2) {
                    this.setEntityArmorWithChance(random, entity, ToolsItems.OsmiumSword, ToolsItems.OsmiumHelmet, ToolsItems.OsmiumChestplate, ToolsItems.OsmiumLeggings, ToolsItems.OsmiumBoots);
                } else if (armorType == 3) {
                    this.setEntityArmorWithChance(random, entity, ToolsItems.SteelSword, ToolsItems.SteelHelmet, ToolsItems.SteelChestplate, ToolsItems.SteelLeggings, ToolsItems.SteelBoots);
                } else if (armorType == 4) {
                    this.setEntityArmorWithChance(random, entity, ToolsItems.BronzeSword, ToolsItems.BronzeHelmet, ToolsItems.BronzeChestplate, ToolsItems.BronzeLeggings, ToolsItems.BronzeBoots);
                }
            }
        }
    }

    public Version getVersion() {
        return versionNumber;
    }

    public String getName() {
        return "Tools";
    }

    public void writeConfig(ByteBuf dataStream, MekanismConfig config) {
        config.tools.write(dataStream);
    }

    public void readConfig(ByteBuf dataStream, MekanismConfig destConfig) {
        destConfig.tools.read(dataStream);
    }

    public void resetClient() {
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID) || event.getModID().equalsIgnoreCase("mekanism")) {
            proxy.loadConfiguration();
        }
    }

    static {
        versionNumber = new Version(9, 7, 9);
        AXE_DAMAGE = new HashMap<Item.ToolMaterial, Float>();
        AXE_SPEED = new HashMap<Item.ToolMaterial, Float>();
    }
}

