/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med.logic;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.reactor.IReactorPlanner;
import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.core.IC2;
import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.inventory.base.IHasInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ReactorLogicBase
implements IReactorPlanner,
IHasInventory,
INetworkFieldData {
    TileEntityReactorPlanner planner;
    public int ticksDone;
    public int ticksLeft;
    public int maxTick;
    public boolean custom;
    public int currentHeat;
    public int maxHeat;
    public float explosionEffect;
    public float production;
    public boolean producing;
    public boolean isExploded;
    public boolean didComponentBreak;
    public boolean isValid;
    public boolean collecting;
    public int fuelPulses;
    public int reEnrichPulses;
    public NonNullList<ItemStack> inv = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);

    public ReactorLogicBase(TileEntityReactorPlanner tile) {
        this.planner = tile;
    }

    public abstract void onTick();

    public abstract void onFinished();

    public abstract void validate();

    public abstract void reset();

    public abstract IReactorPrediction createPrediction();

    public abstract TileEntityReactorPlanner.ReactorBackup createBackup();

    public abstract void restoreFromBackup(TileEntityReactorPlanner.ReactorBackup var1);

    public abstract boolean isSteamLogic();

    public void pauseProduction() {
        this.producing = false;
    }

    public void continueProduction() {
        this.producing = true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean didReactorBreak() {
        return this.didComponentBreak || this.isExploded;
    }

    public boolean isFinished() {
        return this.ticksLeft == 0;
    }

    public TileEntityReactorPlanner getPlanner() {
        return this.planner;
    }

    public int getReactorSize() {
        return 3 + this.getPlanner().reactorSize;
    }

    public void onSizeUpdate() {
        int size;
        for (int x = size = this.getReactorSize(); x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                this.setStackInSlot(y * 9 + x, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.inv.set(slot, (Object)stack);
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.inv.get(slot);
    }

    @Override
    public int getSlotCount() {
        return 54;
    }

    @Override
    public int getMaxStackSize(int slot) {
        return 64;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public TileEntity getCoreTe() {
        return null;
    }

    @Override
    public BlockPos getPosition() {
        return this.getPlanner().func_174877_v();
    }

    @Override
    public World getWorldObj() {
        return this.getPlanner().func_145831_w();
    }

    @Override
    public int getHeat() {
        return this.currentHeat;
    }

    @Override
    public void setHeat(int heat) {
        this.currentHeat = heat;
    }

    @Override
    public int addHeat(int amount) {
        return this.currentHeat += amount;
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public void setMaxHeat(int newMaxHeat) {
        this.maxHeat = newMaxHeat;
    }

    @Override
    public void addEmitHeat(int heat) {
    }

    @Override
    public float getHeatEffectModifier() {
        return this.explosionEffect;
    }

    @Override
    public void setHeatEffectModifier(float newHEM) {
        this.explosionEffect = newHEM;
    }

    @Override
    public float getReactorEnergyOutput() {
        return this.production;
    }

    @Override
    public double getReactorEUEnergyOutput() {
        return this.production * (float)IC2.config.getInt("energyGeneratorNuclear");
    }

    @Override
    public float addOutput(float energy) {
        return this.production += energy;
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        return this.getMatrixItem(x, y);
    }

    @Override
    public void setItemAt(int x, int y, ItemStack item) {
        this.setMatrixItem(x, y, item);
    }

    public void setMatrixItem(int x, int y, ItemStack item) {
        if (x < 0 || x >= this.getReactorSize() || y < 0 || y >= 6) {
            return;
        }
        this.setStackInSlot(y * 9 + x, item);
    }

    public ItemStack getMatrixItem(int x, int y) {
        if (x < 0 || x >= this.getReactorSize() || y < 0 || y >= 6) {
            return ItemStack.field_190927_a;
        }
        return this.getStackInSlot(y * 9 + x);
    }

    @Override
    public void explode() {
    }

    @Override
    public int getTickRate() {
        return 0;
    }

    @Override
    public boolean produceEnergy() {
        return this.producing;
    }

    @Override
    public boolean isFluidCooled() {
        return false;
    }

    public IReactorPlannerComponent getComponent(int slot) {
        ItemStack item = (ItemStack)this.inv.get(slot);
        if (item.func_190926_b()) {
            return null;
        }
        if (item.func_77973_b() instanceof IReactorPlannerComponent) {
            return (IReactorPlannerComponent)item.func_77973_b();
        }
        return null;
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.ticksDone = buffer.readInt();
        this.ticksLeft = buffer.readInt();
        this.maxTick = buffer.readInt();
        this.currentHeat = buffer.readInt();
        this.maxHeat = buffer.readInt();
        this.explosionEffect = buffer.readFloat();
        this.production = buffer.readFloat();
        this.producing = buffer.readBoolean();
        this.isExploded = buffer.readBoolean();
        this.isValid = buffer.readBoolean();
        this.custom = buffer.readBoolean();
    }

    @Override
    public void write(IOutputBuffer buffer) {
        buffer.writeInt(this.ticksDone);
        buffer.writeInt(this.ticksLeft);
        buffer.writeInt(this.maxTick);
        buffer.writeInt(this.currentHeat);
        buffer.writeInt(this.maxHeat);
        buffer.writeFloat(this.explosionEffect);
        buffer.writeFloat(this.production);
        buffer.writeBoolean(this.producing);
        buffer.writeBoolean(this.isExploded);
        buffer.writeBoolean(this.isValid);
        buffer.writeBoolean(this.custom);
    }

    public void readStateFromNBT(NBTTagCompound nbt) {
        this.ticksDone = nbt.func_74762_e("TimeGone");
        this.ticksLeft = nbt.func_74762_e("TimeLeft");
        this.maxTick = nbt.func_74762_e("TotalTime");
        this.currentHeat = nbt.func_74762_e("Heat");
        this.maxHeat = nbt.func_74762_e("MaxHeat");
        this.explosionEffect = nbt.func_74760_g("ExplosionEffect");
        this.production = nbt.func_74760_g("Production");
        this.producing = nbt.func_74767_n("Producing");
        this.isExploded = nbt.func_74767_n("IsExploded");
        this.isValid = nbt.func_74767_n("isValid");
        this.custom = nbt.func_74767_n("Custom");
        NBTTagList list = nbt.func_150295_c("Setup", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            this.inv.set(data.func_74762_e("Slot"), (Object)new ItemStack(data));
        }
    }

    public void writeStateToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("TimeGone", this.ticksDone);
        nbt.func_74768_a("TimeLeft", this.ticksLeft);
        nbt.func_74768_a("TotalTime", this.maxTick);
        nbt.func_74768_a("Heat", this.currentHeat);
        nbt.func_74768_a("MaxHeat", this.maxHeat);
        nbt.func_74776_a("ExplosionEffect", this.explosionEffect);
        nbt.func_74776_a("Production", this.production);
        nbt.func_74757_a("Producing", this.producing);
        nbt.func_74757_a("IsExploded", this.isExploded);
        nbt.func_74757_a("isValid", this.isValid);
        nbt.func_74757_a("Custom", this.custom);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 54; ++i) {
            NBTTagCompound data = new NBTTagCompound();
            ((ItemStack)this.inv.get(i)).func_77955_b(data);
            data.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Setup", (NBTBase)list);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("TimeGone", this.ticksDone);
        nbt.func_74768_a("TimeLeft", this.ticksLeft);
        nbt.func_74768_a("TotalTime", this.maxTick);
        nbt.func_74768_a("Heat", this.currentHeat);
        nbt.func_74768_a("MaxHeat", this.maxHeat);
        nbt.func_74776_a("ExplosionEffect", this.explosionEffect);
        nbt.func_74776_a("Production", this.production);
        nbt.func_74757_a("Producing", this.producing);
        nbt.func_74757_a("IsExploded", this.isExploded);
        nbt.func_74757_a("isValid", this.isValid);
        nbt.func_74757_a("Custom", this.custom);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 54; ++i) {
            NBTTagCompound data = new NBTTagCompound();
            ((ItemStack)this.inv.get(i)).func_77955_b(data);
            data.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Setup", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.ticksDone = nbt.func_74762_e("TimeGone");
        this.ticksLeft = nbt.func_74762_e("TimeLeft");
        this.maxTick = nbt.func_74762_e("TotalTime");
        this.currentHeat = nbt.func_74762_e("Heat");
        this.maxHeat = nbt.func_74762_e("MaxHeat");
        this.explosionEffect = nbt.func_74760_g("ExplosionEffect");
        this.production = nbt.func_74760_g("Production");
        this.producing = nbt.func_74767_n("Producing");
        this.isExploded = nbt.func_74767_n("IsExploded");
        this.isValid = nbt.func_74767_n("isValid");
        this.custom = nbt.func_74767_n("Custom");
        this.inv = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
        NBTTagList list = nbt.func_150295_c("Setup", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            this.inv.set(data.func_74762_e("Slot"), (Object)new ItemStack(data));
        }
    }

    public void clear() {
        this.ticksDone = 0;
        this.ticksLeft = 0;
        this.maxTick = 0;
        this.currentHeat = 0;
        this.maxHeat = 10000;
        this.explosionEffect = 1.0f;
        this.production = 0.0f;
        this.producing = false;
        this.isExploded = false;
        this.isValid = false;
        this.custom = false;
        this.inv = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
    }

    @Override
    public boolean isCollecting() {
        return this.collecting;
    }

    @Override
    public void addFuelPulse() {
        ++this.fuelPulses;
    }

    @Override
    public void addReEnrichPulse() {
        ++this.reEnrichPulses;
    }

    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public static interface IReactorPrediction
    extends INetworkFieldData {
        public void readFromNBT(NBTTagCompound var1);

        public void writeToNBT(NBTTagCompound var1);

        public boolean isSteam();

        public void clear();
    }
}

