/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.misc;

import ic2.api.item.ItemWrapper;
import ic2.core.block.render.model.ModelIronFence;
import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.ICustomModeledBlock;
import ic2.core.util.obj.IBootable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFencePole
extends Block
implements ICustomModeledBlock,
IBootable,
ILocaleBlock {
    public static PropertyBool north = BlockFence.field_176526_a;
    public static PropertyBool south = BlockFence.field_176527_M;
    public static PropertyBool east = BlockFence.field_176525_b;
    public static PropertyBool west = BlockFence.field_176528_N;
    public static PropertyInteger charge = PropertyInteger.func_177719_a((String)"charge", (int)0, (int)15);
    public static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockFencePole() {
        super(Material.field_151573_f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)north, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)south, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)east, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)west, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)charge, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(4.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    @Override
    public LocaleComp getName() {
        return Ic2BlockLang.ironFence;
    }

    @Override
    public void onLoad() {
        Ic2Items.ironFence = new ItemStack((Block)this);
        Ic2States.ironFence = this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{charge, north, south, east, west});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)charge);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)charge, (Comparable)Integer.valueOf(meta));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isPole(IBlockAccess world, BlockPos pos) {
        return this.isPole(this.func_176221_a(world.func_180495_p(pos), world, pos));
    }

    public boolean isPole(IBlockState state) {
        return state.func_177230_c() == this && (Boolean)state.func_177229_b((IProperty)north) == false && (Boolean)state.func_177229_b((IProperty)south) == false && (Boolean)state.func_177229_b((IProperty)east) == false && (Boolean)state.func_177229_b((IProperty)west) == false;
    }

    public boolean canConnect(IBlockAccess worldIn, BlockPos pos, EnumFacing dir) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block == this || block instanceof BlockFence || block.canBeConnectedTo(worldIn, pos, dir);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOXES[BlockFencePole.getBoundingBoxIdx(state)];
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState blockState, World worldIn, BlockPos pos) {
        if (this.isPole(blockState = this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            return new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625).func_186670_a(pos);
        }
        return BOUNDING_BOXES[BlockFencePole.getBoundingBoxIdx(blockState)].func_186670_a(pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess access, BlockPos pos) {
        if (this.isPole(blockState = this.func_176221_a(blockState, access, pos))) {
            return new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
        }
        return BOUNDING_BOXES[BlockFencePole.getBoundingBoxIdx(blockState)].func_186666_e(1.5);
    }

    private static int getBoundingBoxIdx(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)north)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)east)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)south)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)west)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)north, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos.func_177978_c(), EnumFacing.SOUTH))).func_177226_a((IProperty)south, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos.func_177968_d(), EnumFacing.NORTH))).func_177226_a((IProperty)east, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos.func_177974_f(), EnumFacing.WEST))).func_177226_a((IProperty)west, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos.func_177976_e(), EnumFacing.EAST)));
    }

    @Override
    public List<IBlockState> getValidModelStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromState(IBlockState state) {
        return new ModelIronFence(state, state == this.func_176223_P());
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176223_P();
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        boolean shoes;
        if (!(entityIn instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityIn;
        boolean powered = (Integer)state.func_177229_b((IProperty)charge) != 0;
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
        boolean bl = shoes = stack != null && ItemWrapper.isMetalArmor(stack, player);
        if (!powered || !shoes) {
            if (player.func_70093_af()) {
                if (player.field_70181_x < -0.25) {
                    EntityPlayer entityPlayer = player;
                    entityPlayer.field_70181_x *= (double)0.9f;
                } else {
                    player.field_70143_R = 0.0f;
                }
            }
        } else {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)charge, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)charge) - 1)));
            EntityPlayer entityPlayer2 = player;
            entityPlayer2.field_70181_x += (double)0.075f;
            if (player.field_70181_x > 0.0) {
                EntityPlayer entityPlayer3 = player;
                entityPlayer3.field_70181_x *= 1.029999971389771;
                player.field_70143_R = 0.0f;
            }
            if (player.func_70093_af()) {
                if (player.field_70181_x > 0.300000011920929) {
                    player.field_70181_x = 0.300000011920929;
                }
            } else if (player.field_70181_x > 1.5) {
                player.field_70181_x = 1.5;
            }
        }
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.CENTER;
    }
}

