/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.core.item.armor.base.ItemArmorElectricJetpackBase;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class ItemArmorElectricJetpack
extends ItemArmorElectricJetpackBase {
    public ItemArmorElectricJetpack() {
        super(39, EntityEquipmentSlot.CHEST);
        this.setUnlocalizedName(Ic2ItemLang.jetpackElectric);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canDisable(ItemStack stack) {
        return true;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 30000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 60.0;
    }

    @Override
    public boolean canDoRocketMode(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canDoAdvHoverMode(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isElectricJetpack(ItemStack stack) {
        return true;
    }

    @Override
    public float getPower(ItemStack stack) {
        return 0.7f;
    }

    @Override
    public float getThruster(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
        return mode == ItemArmorJetpackBase.HoverMode.Basic ? 0.65f : 0.3f;
    }

    @Override
    public float getDropPercentage(ItemStack stack) {
        return 0.05f;
    }

    @Override
    public int getMaxHeight(ItemStack stack, int worldHeight) {
        return (int)((float)worldHeight / 1.28f);
    }

    @Override
    public int getMaxRocketCharge(ItemStack stack) {
        return 0;
    }

    @Override
    public int getFuelCost(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
        return mode == ItemArmorJetpackBase.HoverMode.Basic ? 4 : 7;
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/jetpack_Electric";
    }
}

