/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.tileentity;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.tile.IMachine;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.resources.BlockRubberWood;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.network.NetworkManager;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import trinsdar.ic2c_extras.container.ContainerTreeTapper;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasResourceLocations;

public class TileEntityTreeTapper
extends TileEntityElecMachine
implements ITickable,
IHasGui,
IMachine {
    public int nextDelay = 10;
    public int delay = 0;
    public int radius = 1;

    public TileEntityTreeTapper() {
        super(13, 128);
        this.maxEnergy = 50000;
    }

    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Export, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
        handler.registerSlotType(SlotType.Output, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
    }

    public boolean supportsNotify() {
        return true;
    }

    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerTreeTapper(player.field_71071_by, this);
    }

    public Class<? extends GuiScreen> getGuiClass(EntityPlayer entityPlayer) {
        return GuiComponentContainer.class;
    }

    public ResourceLocation getTexture() {
        return Ic2cExtrasResourceLocations.treeTapper;
    }

    public LocaleComp getBlockName() {
        return Ic2cExtrasLang.treeTapper;
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public double getWrenchDropRate() {
        return 1.0;
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return true;
    }

    public boolean hasGui(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_73660_a() {
        World worldIn = this.func_145831_w();
        this.updateNeighbors();
        if (this.delay > 0) {
            --this.delay;
        } else if (!this.hasEnergy(100)) {
            this.delay += 20;
        } else if (this.isInventoryFull()) {
            this.delay += 20;
        } else {
            this.delay += this.nextDelay;
            this.setActive(true);
            for (BlockPos additionalPos : this.getTargetBlocks(this.func_174877_v())) {
                ItemStack stack = StackUtil.copyWithSize((ItemStack)Ic2Items.stickyResin, (int)(1 + worldIn.field_73012_v.nextInt(3)));
                boolean server = IC2.platform.isSimulating();
                if (server && TileEntityTreeTapper.attemptExtract(worldIn, additionalPos, true) && !this.isInventoryFull() && this.addItemsToInventory(stack, true)) {
                    TileEntityTreeTapper.attemptExtract(worldIn, additionalPos, false);
                    this.addItemsToInventory(stack, false);
                    this.useEnergy(20);
                    continue;
                }
                if (!this.isInventoryFull()) continue;
                break;
            }
            this.setActive(false);
            this.useEnergy(100);
        }
    }

    public boolean isInventoryFull() {
        int fullSlotCount = 0;
        for (int i = 0; i < 9; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190916_E() != 64) continue;
            ++fullSlotCount;
        }
        return fullSlotCount == 9;
    }

    public static boolean attemptExtract(World world, BlockPos pos, boolean simulate) {
        IBlockState state = world.func_180495_p(pos);
        if (((Boolean)state.func_177229_b((IProperty)BlockRubberWood.resin)).booleanValue()) {
            boolean server = IC2.platform.isSimulating();
            if (((Boolean)state.func_177229_b((IProperty)BlockRubberWood.collectable)).booleanValue() && server) {
                if (!simulate) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)BlockRubberWood.collectable, (Comparable)Boolean.valueOf(false)));
                    world.func_175684_a(pos, state.func_177230_c(), 100);
                    ((NetworkManager)IC2.network.get(server)).announceBlockUpdate(world, pos);
                }
                return true;
            }
        }
        return false;
    }

    public Set<BlockPos> getTargetBlocks(BlockPos pos) {
        LinkedHashSet<BlockPos> targetBlocks = new LinkedHashSet<BlockPos>();
        for (int y = 0; y < 8; ++y) {
            for (int x = -this.radius; x < this.radius + 1; ++x) {
                for (int z = -this.radius; z < this.radius + 1; ++z) {
                    BlockPos newPos = pos.func_177982_a(x, y, z);
                    IBlockState state = this.func_145831_w().func_180495_p(newPos);
                    if (state.func_177230_c() != Ic2States.rubberWood.func_177230_c()) continue;
                    targetBlocks.add(newPos);
                }
            }
        }
        return targetBlocks;
    }

    public boolean addItemsToInventory(ItemStack stack, boolean simulate) {
        for (int i = 0; i < 9; ++i) {
            if (!((ItemStack)this.inventory.get(i)).func_190926_b() && this.getStackInSlot(i).func_190916_E() + stack.func_190916_E() > 67) continue;
            if (!simulate) {
                int count = this.getStackInSlot(i).func_190916_E() + stack.func_190916_E();
                this.setStackInSlot(i, StackUtil.copyWithSize((ItemStack)Ic2Items.stickyResin, (int)count));
            }
            return true;
        }
        return false;
    }

    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.setOverclockerUpgrade();
        }
    }

    public void setOverclockerUpgrade() {
        int overclocker = 0;
        int newRange = 1;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (StackUtil.isStackEqual((ItemStack)stack, (ItemStack)Ic2Items.overClockerUpgrade)) {
                overclocker += stack.func_190916_E();
                continue;
            }
            if (StackUtil.isStackEqual((ItemStack)stack, (ItemStack)Ic2Items.padUpgradeBasicFieldUpgrade)) {
                ++newRange;
                continue;
            }
            if (StackUtil.isStackEqual((ItemStack)stack, (ItemStack)Ic2Items.padUpgradeFieldUpgrade)) {
                newRange += 2;
                continue;
            }
            if (!StackUtil.isStackEqual((ItemStack)stack, (ItemStack)Ic2Items.padUpgradeAdvFieldUpgrade)) continue;
            newRange += 3;
        }
        if (newRange > 5) {
            newRange = 5;
        }
        this.radius = newRange;
        if (overclocker < 1) {
            this.nextDelay = 20;
        } else if (overclocker < 2) {
            this.nextDelay = 10;
        } else if (overclocker < 3) {
            this.nextDelay = 5;
        } else if (overclocker < 4) {
            this.nextDelay = 2;
        } else if (overclocker >= 4) {
            this.nextDelay = 0;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.delay = nbt.func_74762_e("Delay");
        this.radius = nbt.func_74762_e("Radius");
        this.nextDelay = nbt.func_74762_e("NextDelay");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Delay", this.delay);
        nbt.func_74768_a("Radius", this.radius);
        nbt.func_74768_a("NextDelay", this.nextDelay);
        return nbt;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount, boolean simulate) {
        if ((double)this.energy < amount) {
            return false;
        }
        if (!simulate) {
            this.useEnergy((int)amount);
        }
        return true;
    }

    public void setRedstoneSensitive(boolean b) {
    }

    public boolean isRedstoneSensitive() {
        return false;
    }

    public boolean isProcessing() {
        return false;
    }

    public boolean isValidInput(ItemStack itemStack) {
        return false;
    }

    public Set<IMachineUpgradeItem.UpgradeType> getSupportedTypes() {
        return new LinkedHashSet<IMachineUpgradeItem.UpgradeType>(Arrays.asList(IMachineUpgradeItem.UpgradeType.values()));
    }

    public World getMachineWorld() {
        return this.func_145831_w();
    }

    public BlockPos getMachinePos() {
        return this.func_174877_v();
    }
}

