/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.caffeine.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import me.lucko.luckperms.lib.caffeine.base.UnsafeAccess;
import me.lucko.luckperms.lib.caffeine.cache.Node;
import me.lucko.luckperms.lib.caffeine.cache.NodeFactory;
import me.lucko.luckperms.lib.caffeine.cache.References;

class PW<K, V>
extends Node<K, V>
implements NodeFactory<K, V> {
    protected static final long KEY_OFFSET = UnsafeAccess.objectFieldOffset(PW.class, "key");
    protected static final long VALUE_OFFSET = UnsafeAccess.objectFieldOffset(PW.class, "value");
    volatile K key;
    volatile References.WeakValueReference<V> value;

    PW() {
    }

    PW(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        this(k, v, referenceQueue2, n, l);
    }

    PW(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, object);
        UnsafeAccess.UNSAFE.putObject(this, VALUE_OFFSET, new References.WeakValueReference<V>(object, v, referenceQueue));
    }

    @Override
    public final K getKey() {
        return (K)UnsafeAccess.UNSAFE.getObject(this, KEY_OFFSET);
    }

    @Override
    public final Object getKeyReference() {
        return UnsafeAccess.UNSAFE.getObject(this, KEY_OFFSET);
    }

    @Override
    public final V getValue() {
        return (V)((Reference)UnsafeAccess.UNSAFE.getObject(this, VALUE_OFFSET)).get();
    }

    @Override
    public final Object getValueReference() {
        return UnsafeAccess.UNSAFE.getObject(this, VALUE_OFFSET);
    }

    @Override
    public final void setValue(V v, ReferenceQueue<V> referenceQueue) {
        ((Reference)this.getValueReference()).clear();
        UnsafeAccess.UNSAFE.putObject(this, VALUE_OFFSET, new References.WeakValueReference<V>(this.getKeyReference(), v, referenceQueue));
    }

    @Override
    public final boolean containsValue(Object object) {
        return this.getValue() == object;
    }

    @Override
    public Node<K, V> newNode(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        return new PW<K, V>(k, referenceQueue, v, referenceQueue2, n, l);
    }

    @Override
    public Node<K, V> newNode(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        return new PW<K, V>(object, v, referenceQueue, n, l);
    }

    @Override
    public boolean weakValues() {
        return true;
    }

    @Override
    public final boolean isAlive() {
        Object object = this.getKeyReference();
        return object != RETIRED_STRONG_KEY && object != DEAD_STRONG_KEY;
    }

    @Override
    public final boolean isRetired() {
        return this.getKeyReference() == RETIRED_STRONG_KEY;
    }

    @Override
    public final void retire() {
        ((Reference)this.getValueReference()).clear();
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, RETIRED_STRONG_KEY);
    }

    @Override
    public final boolean isDead() {
        return this.getKeyReference() == DEAD_STRONG_KEY;
    }

    @Override
    public final void die() {
        ((Reference)this.getValueReference()).clear();
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, DEAD_STRONG_KEY);
    }
}

