/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.caffeine.cache;

import me.lucko.luckperms.lib.caffeine.cache.CacheLoader;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.Expiry;
import me.lucko.luckperms.lib.caffeine.cache.Ticker;
import me.lucko.luckperms.lib.caffeine.cache.TimerWheel;
import me.lucko.luckperms.lib.caffeine.cache.WIMW;

class WIMWA<K, V>
extends WIMW<K, V> {
    final Ticker ticker;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;

    WIMWA(Caffeine<K, V> caffeine, CacheLoader<? super K, V> cacheLoader, boolean bl) {
        super(caffeine, cacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.expiry = caffeine.getExpiry(this.isAsync);
        this.timerWheel = caffeine.expiresVariable() ? new TimerWheel(this) : null;
        this.expiresAfterAccessNanos = caffeine.getExpiresAfterAccessNanos();
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    protected final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long l) {
        this.expiresAfterAccessNanos = l;
    }
}

