/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.crafttweaker.handlers;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.recipes.PlasticMixerRegistry;
import me.desht.pneumaticcraft.common.recipes.PneumaticRecipeRegistry;
import me.desht.pneumaticcraft.common.thirdparty.crafttweaker.CraftTweaker;
import me.desht.pneumaticcraft.common.thirdparty.crafttweaker.util.Helper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.pneumaticcraft.plasticmixer")
@ZenRegister
public class PlasticMixer {
    private static final String NAME = "PneumaticCraft Plastic Mixer";

    @ZenMethod
    public static void addRecipe(ILiquidStack liquid, IItemStack stack, int temperature) {
        CraftTweaker.ADDITIONS.add(new LiquidPlasticAction(Helper.toFluid(liquid), Helper.toStack(stack), temperature, true, true));
    }

    @ZenMethod
    public static void addMeltOnlyRecipe(IItemStack stackInput, ILiquidStack liquidOutput, int temperature) {
        CraftTweaker.ADDITIONS.add(new LiquidPlasticAction(Helper.toFluid(liquidOutput), Helper.toStack(stackInput), temperature, true, false));
    }

    @ZenMethod
    public static void addSolidifyOnlyRecipe(ILiquidStack liquidInput, IItemStack stackOutput) {
        CraftTweaker.ADDITIONS.add(new LiquidPlasticAction(Helper.toFluid(liquidInput), Helper.toStack(stackOutput), 0, false, true));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack liquidInput) {
        CraftTweaker.REMOVALS.add(new LiquidPlasticAction(Helper.toFluid(liquidInput).getFluid(), 0));
    }

    @ZenMethod
    public static void removeAllRecipes() {
        CraftTweaker.REMOVALS.add(new IAction(){

            public void apply() {
                PlasticMixerRegistry.INSTANCE.clear();
            }

            public String describe() {
                return "Removing all PneumaticCraft Plastic Mixer recipes.";
            }
        });
    }

    private static class LiquidPlasticAction
    implements IAction {
        private final FluidStack fluidStack;
        private final ItemStack stack;
        private final int temperature;
        private final boolean allowMelting;
        private final boolean allowSolidifying;

        LiquidPlasticAction(FluidStack fluidStack, ItemStack stack, int temperature, boolean allowMelting, boolean allowSolidifying) {
            this.fluidStack = fluidStack;
            this.stack = stack;
            this.temperature = temperature;
            this.allowMelting = allowMelting;
            this.allowSolidifying = allowSolidifying;
        }

        LiquidPlasticAction(FluidStack fluidStack, ItemStack stack) {
            this.fluidStack = fluidStack;
            this.stack = stack;
            this.allowMelting = true;
            this.allowSolidifying = true;
            this.temperature = 423;
        }

        LiquidPlasticAction(Fluid fluid, int ratio) {
            this(new FluidStack(fluid, ratio), new ItemStack(Itemss.PLASTIC));
        }

        public void apply() {
            PneumaticRecipeRegistry.getInstance().registerPlasticMixerRecipe(this.fluidStack, this.stack, this.temperature, this.allowMelting, this.allowSolidifying);
        }

        public String describe() {
            if (this.fluidStack.amount == 0) {
                return String.format("Removing recipe for fluid %s", this.fluidStack.getFluid().getName());
            }
            return String.format("Registering recipe for fluid %s as %d mB per item.", this.fluidStack.getFluid().getName(), this.fluidStack.amount);
        }
    }
}

