/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.igwmod;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Desktop;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class IGWSupportNotifier {
    private String supportingMod;
    private static final String LATEST_DL_URL = "http://minecraft.curseforge.com/mc-mods/223815-in-game-wiki-mod/files/latest";
    private static final String DL_URL_1_7_10 = "http://minecraft.curseforge.com/mc-mods/223815-in-game-wiki-mod/files/2247673/download";

    public IGWSupportNotifier() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && !Loader.isModLoaded((String)"IGWMod")) {
            File dir = new File(".", "config");
            Configuration config = new Configuration(new File(dir, "IGWMod.cfg"));
            config.load();
            if (config.get("general", "enable_missing_notification", true, "When enabled, this will notify players when IGW-Mod is not installed even though mods add support.").getBoolean()) {
                ModContainer mc = Loader.instance().activeModContainer();
                String modid = mc.getModId();
                List loadedMods = Loader.instance().getActiveModList();
                for (ModContainer container : loadedMods) {
                    if (!container.getModId().equals(modid)) continue;
                    this.supportingMod = container.getName();
                    MinecraftForge.EVENT_BUS.register((Object)this);
                    ClientCommandHandler.instance.func_71560_a((ICommand)new CommandDownloadIGW());
                    break;
                }
            }
            config.save();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K && event.player == FMLClientHandler.instance().getClientPlayerEntity()) {
            event.player.func_146105_b(ITextComponent.Serializer.func_150699_a((String)("[\"" + TextFormatting.GOLD + "The mod " + this.supportingMod + " is supporting In-Game Wiki mod. " + TextFormatting.GOLD + "However, In-Game Wiki isn't installed! [\",{\"text\":\"Download Latest\",\"color\":\"green\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/igwmod_download\"}},\"]\"]")), false);
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    private class ThreadDownloadIGW
    extends Thread {
        public ThreadDownloadIGW() {
            this.setName("IGW-Mod Download Thread");
            this.start();
        }

        @Override
        public void run() {
            try {
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Downloading IGW-Mod..."), false);
                }
                URL url = new URL("1.12.2".equals("1.7.10") ? IGWSupportNotifier.DL_URL_1_7_10 : IGWSupportNotifier.LATEST_DL_URL);
                URLConnection connection = url.openConnection();
                connection.connect();
                File dir = new File(".", "mods");
                File tempFile = File.createTempFile("IGW-Mod.jar", "");
                FileUtils.copyURLToFile((URL)url, (File)tempFile);
                ZipFile jar = new ZipFile(tempFile.getAbsolutePath());
                Enumeration<? extends ZipEntry> entries = jar.entries();
                InputStream mcmodInfo = null;
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equals("mcmod.info")) continue;
                    mcmodInfo = jar.getInputStream(entry);
                    break;
                }
                JsonParser parser = new JsonParser();
                JsonObject obj = (JsonObject)((JsonArray)parser.parse(IOUtils.toString(mcmodInfo))).get(0);
                jar.close();
                String version = obj.get("version").getAsString();
                String mcVersion = obj.get("mcversion").getAsString();
                File renamedFile = new File(String.format("." + File.separator + "mods" + File.separator + "IGW-Mod-%s-%s-universal.jar", mcVersion, version));
                FileUtils.copyFile((File)tempFile, (File)renamedFile);
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Successfully downloaded. Restart Minecraft to apply."), false);
                }
                Desktop.getDesktop().open(dir);
                if (!"1.12.2".equals(mcVersion) && Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "The version of Minecraft you are running doesn't seem to match the version of IGW-Mod that has been downloaded. The mod may not work."), false);
                }
                this.finalize();
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Failed to download"), false);
                }
                try {
                    this.finalize();
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private class CommandDownloadIGW
    extends CommandBase {
        private CommandDownloadIGW() {
        }

        public int func_82362_a() {
            return -100;
        }

        public String func_71517_b() {
            return "igwmod_download";
        }

        public String func_71518_a(ICommandSender sender) {
            return this.func_71517_b();
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            new ThreadDownloadIGW();
        }
    }
}

