/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.client.gui;

import gcewing.sg.BaseGui;
import gcewing.sg.SGCraft;
import gcewing.sg.container.PowerContainer;
import gcewing.sg.tileentity.PowerTE;
import java.text.DecimalFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class PowerScreen
extends BaseGui.Screen {
    public static int guiWidth = 148;
    public static int guiHeight = 64;
    private final DecimalFormat dFormat = new DecimalFormat("###,###,###");
    private PowerTE te;

    public static PowerScreen create(EntityPlayer player, World world, BlockPos pos) {
        PowerContainer container = PowerContainer.create(player, world, pos);
        if (container != null) {
            return new PowerScreen(container);
        }
        return null;
    }

    private PowerScreen(PowerContainer container) {
        super(container, guiWidth, guiHeight);
        this.te = container.te;
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    protected void drawBackgroundLayer() {
        this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/power_gui.png"), 148, 64);
        this.drawTexturedRect(0.0, 0.0, guiWidth, guiHeight, 0.0, 0.0);
        int cx = this.field_146999_f / 2;
        this.drawCenteredString(this.te.getScreenTitle(), cx, 8);
        this.drawRightAlignedString(this.te.getUnitName() + ":", 90, 23);
        this.drawRightAlignedString(this.dFormat.format(Math.min(Math.max(this.te.energyBuffer, 0.0), this.te.energyMax)), 141, 23);
        if (SGCraft.displayGuiPowerDebug) {
            this.drawRightAlignedString("SGPU:", 90, 34);
            this.drawRightAlignedString(this.dFormat.format(Math.min(Math.max(this.te.energyBuffer / this.te.energyPerSGEnergyUnit, 0.0), this.te.energyMax)), 141, 34);
        }
        this.drawRightAlignedString("Max:", 90, 45);
        this.drawRightAlignedString(this.dFormat.format(this.te.energyMax), 141, 45);
        this.drawPowerGauge();
    }

    private void drawPowerGauge() {
        this.gSave();
        GL11.glPushAttrib((int)8193);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        this.setColor(1.0, 0.0, 0.0);
        this.drawRect(23.0, 28.0, 29.0 * this.te.energyBuffer / this.te.energyMax, 10.0);
        GL11.glBlendFunc((int)1, (int)0);
        GL11.glPopAttrib();
        this.gRestore();
    }
}

