/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.math.Vec3d;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.service.permission.MemorySubjectData;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.command.CommandSenderBridge;
import org.spongepowered.common.command.CommandPermissions;
import org.spongepowered.common.command.WrapperICommandSender;
import org.spongepowered.common.service.permission.base.SpongeSubject;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.VecHelper;

public class WrapperCommandSource
extends SpongeSubject
implements CommandSource {
    final ICommandSender sender;
    private final PermissionService service;
    private final MemorySubjectData data;

    private WrapperCommandSource(ICommandSender sender) {
        this.sender = sender;
        this.service = SpongeImpl.getGame().getServiceManager().provideUnchecked(PermissionService.class);
        this.data = new MemorySubjectData(this.service);
        CommandPermissions.populateMinecraftPermissions(sender, this.data);
    }

    @Override
    public PermissionService getService() {
        return this.service;
    }

    @Override
    public String getIdentifier() {
        return this.sender.func_70005_c_();
    }

    @Override
    public Optional<CommandSource> getCommandSource() {
        return Optional.of(this);
    }

    @Override
    public SubjectCollection getContainingCollection() {
        return this.service.loadCollection("system").join();
    }

    @Override
    public MemorySubjectData getSubjectData() {
        return this.data;
    }

    @Override
    public String getName() {
        return this.sender.func_70005_c_();
    }

    @Override
    public void sendMessage(Text message) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        this.sender.func_145747_a(SpongeTexts.toComponent(message));
    }

    @Override
    public MessageChannel getMessageChannel() {
        return SpongeImpl.getGame().getServer().getBroadcastChannel();
    }

    @Override
    public void setMessageChannel(MessageChannel channel) {
    }

    public static CommandSource of(ICommandSender sender) {
        if (sender instanceof CommandSenderBridge) {
            return ((CommandSenderBridge)sender).bridge$asCommandSource();
        }
        if (sender instanceof WrapperICommandSender) {
            return ((WrapperICommandSender)sender).source;
        }
        if (sender.func_174793_f() != null || !Vec3d.field_186680_a.equals((Object)sender.func_174791_d())) {
            return new Located(sender);
        }
        return new WrapperCommandSource(sender);
    }

    public static class Located
    extends WrapperCommandSource
    implements Locatable {
        Located(ICommandSender sender) {
            super(sender);
        }

        @Override
        public Location<World> getLocation() {
            return new Location<World>((World)this.sender.func_130014_f_(), VecHelper.toVector3d(this.sender.func_174791_d()));
        }
    }
}

