/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.Types;
import ninja.leaping.configurate.ValueType;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.commented.SimpleCommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import ninja.leaping.configurate.util.ConfigurationNodeWalker;
import org.spongepowered.api.util.Functional;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.type.ConfigBase;
import org.spongepowered.common.config.type.CustomDataConfig;
import org.spongepowered.common.config.type.DimensionConfig;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.TrackerConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.util.IpSet;

public class SpongeConfig<T extends ConfigBase> {
    private static final String HEADER = "1.0\n\n# If you need help with the configuration or have any questions related to Sponge,\n# join us at the IRC or drop by our forums and leave a post.\n\n# IRC: #sponge @ irc.esper.net ( https://webchat.esper.net/?channel=sponge )\n# Forums: https://forums.spongepowered.org/\n";
    private static final ConfigurationOptions LOADER_OPTIONS = ConfigurationOptions.defaults().setHeader("1.0\n\n# If you need help with the configuration or have any questions related to Sponge,\n# join us at the IRC or drop by our forums and leave a post.\n\n# IRC: #sponge @ irc.esper.net ( https://webchat.esper.net/?channel=sponge )\n# Forums: https://forums.spongepowered.org/\n").setSerializers(TypeSerializers.getDefaultSerializers().newChild().registerType(TypeToken.of(IpSet.class), new IpSet.IpSetSerializer()));
    private final Type type;
    @Nullable
    private final SpongeConfig<?> parent;
    private HoconConfigurationLoader loader;
    private CommentedConfigurationNode fileData = SimpleCommentedConfigurationNode.root(LOADER_OPTIONS);
    private CommentedConfigurationNode data = SimpleCommentedConfigurationNode.root(LOADER_OPTIONS);
    private ObjectMapper.BoundInstance configMapper;
    private final String modId;
    private final boolean isDummy;

    public static <T extends ConfigBase> SpongeConfig<T> newDummyConfig(Type type) {
        return new SpongeConfig<T>(type);
    }

    private SpongeConfig(Type type) {
        this.type = type;
        this.parent = null;
        this.modId = null;
        this.isDummy = true;
        try {
            this.configMapper = ObjectMapper.forClass(this.type.type).bindToNew();
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Failed to initialize dummy configuration", (Throwable)e);
        }
    }

    public SpongeConfig(Type type, Path path, String modId, SpongeConfig<?> parent, boolean forceSaveOnLoad) {
        this.type = type;
        this.parent = parent;
        this.modId = modId;
        this.isDummy = false;
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
            this.configMapper = ObjectMapper.forClass(this.type.type).bindToNew();
            if (!this.load()) {
                return;
            }
            if (!forceSaveOnLoad && parent != null && parent.parent != null) {
                this.saveNow();
            } else if (forceSaveOnLoad) {
                this.saveNow();
            }
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Failed to initialize configuration", (Throwable)e);
        }
    }

    public T getConfig() {
        return (T)((ConfigBase)this.configMapper.getInstance());
    }

    public void save() {
        if (this.isDummy) {
            return;
        }
        SpongeImpl.getConfigSaveManager().save(this);
    }

    public boolean saveNow() {
        if (this.isDummy) {
            return false;
        }
        try {
            SimpleCommentedConfigurationNode saveNode = SimpleCommentedConfigurationNode.root(LOADER_OPTIONS);
            this.configMapper.serialize(saveNode.getNode(this.modId));
            if (this.parent != null) {
                this.removeDuplicates(saveNode);
            }
            this.loader.save(saveNode);
            if (this.parent != null) {
                this.parent.saveNow();
            }
            return true;
        }
        catch (IOException | ObjectMappingException e) {
            SpongeImpl.getLogger().error("Failed to save configuration", (Throwable)e);
            return false;
        }
    }

    public boolean load() {
        if (this.isDummy) {
            return true;
        }
        if (!SpongeImpl.getConfigSaveManager().flush(this)) {
            SpongeImpl.getLogger().error("Failed to load configuration due to error in flushing config");
            return false;
        }
        try {
            CommentedConfigurationNode loadedNode;
            this.fileData = loadedNode = (CommentedConfigurationNode)this.loader.load();
            this.data = this.fileData.copy();
            if (this.parent != null) {
                this.parent.load();
                this.data.mergeValuesFrom(this.parent.data);
            }
            this.populateInstance();
            return true;
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Failed to load configuration", (Throwable)e);
            return false;
        }
    }

    private void populateInstance() throws ObjectMappingException {
        if (this.isDummy) {
            return;
        }
        this.configMapper.populate(this.data.getNode(this.modId));
    }

    private void removeDuplicates(CommentedConfigurationNode root) {
        if (this.isDummy) {
            return;
        }
        if (this.parent == null) {
            throw new IllegalStateException("parent is null");
        }
        Iterator<ConfigurationNodeWalker.VisitedNode<CommentedConfigurationNode>> it = ConfigurationNodeWalker.DEPTH_FIRST_POST_ORDER.walkWithPath(root);
        while (it.hasNext()) {
            Double parentVal;
            ConfigurationNodeWalker.VisitedNode<CommentedConfigurationNode> next = it.next();
            CommentedConfigurationNode node = next.getNode();
            if (node.hasMapChildren()) {
                if (!node.getChildrenMap().isEmpty()) continue;
                node.setValue(null);
                continue;
            }
            if (node.getParent() != null && node.getParent().getValueType() == ValueType.LIST) continue;
            CommentedConfigurationNode parentValue = this.parent.data.getNode(next.getPath().getArray());
            if (Objects.equals(node.getValue(), parentValue.getValue())) {
                node.setValue(null);
                continue;
            }
            if (parentValue.getValue() == null && node.getValueType() == ValueType.LIST) {
                List nodeList = (List)node.getValue();
                if (!nodeList.isEmpty()) continue;
                node.setValue(null);
                continue;
            }
            Double nodeVal = node.getValue(Types::asDouble);
            if (nodeVal == null || ((parentVal = parentValue.getValue(Types::asDouble)) != null || nodeVal != 0.0) && (parentVal == null || nodeVal.doubleValue() != parentVal.doubleValue())) continue;
            node.setValue(null);
        }
    }

    public CompletableFuture<CommentedConfigurationNode> updateSetting(String key, Object value) {
        return Functional.asyncFailableFuture(() -> {
            CommentedConfigurationNode upd = this.getSetting(key);
            upd.setValue(value);
            this.populateInstance();
            this.saveNow();
            return upd;
        }, ForkJoinPool.commonPool());
    }

    public <V> CompletableFuture<CommentedConfigurationNode> updateSetting(String key, V value, TypeToken<V> token) {
        return Functional.asyncFailableFuture(() -> {
            CommentedConfigurationNode upd = this.getSetting(key);
            upd.setValue(token, value);
            this.populateInstance();
            this.save();
            return upd;
        }, ForkJoinPool.commonPool());
    }

    public CommentedConfigurationNode getRootNode() {
        return this.data.getNode(this.modId);
    }

    @Nullable
    public CommentedConfigurationNode getSetting(String key) {
        if (key.equalsIgnoreCase("config-enabled")) {
            return this.getRootNode().getNode(key);
        }
        if (!key.contains(".") || key.indexOf(46) == key.length() - 1) {
            return null;
        }
        CommentedConfigurationNode node = this.getRootNode();
        String[] split = key.split("\\.");
        return node.getNode(split);
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        CUSTOM_DATA(CustomDataConfig.class),
        TRACKER(TrackerConfig.class),
        GLOBAL(GlobalConfig.class),
        DIMENSION(DimensionConfig.class),
        WORLD(WorldConfig.class);

        final Class<? extends ConfigBase> type;

        private Type(Class<? extends ConfigBase> type) {
            this.type = type;
        }
    }
}

