/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import javax.annotation.Nullable;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhaseContext;

public class CommandPhaseContext
extends GeneralPhaseContext<CommandPhaseContext> {
    @Nullable
    String command;
    @Nullable
    private TrackedInventoryBridge inventory;

    CommandPhaseContext(IPhaseState<CommandPhaseContext> state) {
        super(state);
    }

    @Override
    public boolean hasCaptures() {
        return this.inventory != null && !this.inventory.bridge$getCapturedSlotTransactions().isEmpty() || super.hasCaptures();
    }

    @Override
    protected void reset() {
        super.reset();
        this.command = null;
        this.inventory = null;
    }

    public CommandPhaseContext command(String command) {
        this.command = command;
        return this;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        super.printCustom(printer, indent).add(s + "- %s: %s", "Command", this.command == null ? "empty command" : this.command);
        if (this.inventory != null) {
            printer.add(s + "-%s: %s", "Inventory", this.inventory.bridge$getCapturedSlotTransactions());
        }
        return printer;
    }

    public CommandPhaseContext inventory(TrackedInventoryBridge inventory) {
        this.inventory = inventory;
        return this;
    }
}

