/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.shop;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.shop.Shop;
import java.math.BigDecimal;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@ConfigSerializable
public class aToggle
extends Shop {
    @Setting
    private Location<World> lever;
    @Setting
    private float price;
    private static String type = "aToggle";

    public aToggle() {
    }

    public aToggle(Player player, Location<World> sign) throws ExceptionInInitializerError {
        super(sign);
        if (!player.hasPermission("carrotshop.admin.device")) {
            throw new ExceptionInInitializerError(Lang.SHOP_PERM.replace("%type%", type));
        }
        Stack<Location<World>> locations = ShopsData.getItemLocations(player);
        if (locations.isEmpty()) {
            throw new ExceptionInInitializerError(Lang.SHOP_LEVER.replace("%type%", type));
        }
        BlockState targetBlock = locations.peek().getBlock();
        if (!targetBlock.getType().equals(BlockTypes.LEVER)) {
            throw new ExceptionInInitializerError(Lang.SHOP_LEVER.replace("%type%", type));
        }
        this.lever = locations.peek();
        if (CarrotShop.getEcoService() != null) {
            this.price = aToggle.getPrice(sign);
            if (this.price < 0.0f) {
                throw new ExceptionInInitializerError(Lang.SHOP_PRICE);
            }
        }
        ShopsData.clearItemLocations(player);
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, Lang.SHOP_DONE.replace("%type%", type)}));
        this.done(player);
        this.info(player);
    }

    @Override
    public List<Location<World>> getLocations() {
        List<Location<World>> locations = super.getLocations();
        locations.add(this.lever);
        return locations;
    }

    @Override
    public void info(Player player) {
        if (CarrotShop.getEcoService() != null) {
            player.sendMessage((Text)Text.of((String)Lang.SHOP_TOGGLE_HELP.replace("%price%", this.formatPrice(this.price))));
        } else {
            player.sendMessage((Text)Text.of((String)Lang.SHOP_TOGGLE_HELP_NOECON));
        }
        this.update();
    }

    @Override
    public boolean trigger(Player player) {
        if (CarrotShop.getEcoService() != null) {
            UniqueAccount buyerAccount = (UniqueAccount)CarrotShop.getEcoService().getOrCreateAccount(player.getUniqueId()).get();
            TransactionResult result = buyerAccount.withdraw(this.getCurrency(), BigDecimal.valueOf(this.price), CarrotShop.getCause());
            if (result.getResult() != ResultType.SUCCESS) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.SHOP_MONEY}));
                return false;
            }
            player.sendMessage((Text)Text.of((String)Lang.SHOP_TOGGLE.replace("%price%", this.formatPrice(this.price))));
        } else {
            player.sendMessage((Text)Text.of((String)Lang.SHOP_TOGGLE_NOECON));
        }
        this.lever.offer(Keys.POWERED, (Object)true);
        Sponge.getScheduler().createTaskBuilder().execute((Consumer)new Consumer<Task>(){

            @Override
            public void accept(Task t) {
                t.cancel();
                aToggle.this.lever.offer(Keys.POWERED, (Object)false);
            }
        }).delay(2L, TimeUnit.SECONDS).submit((Object)CarrotShop.getInstance());
        return true;
    }
}

