/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.reference;

import com.google.common.base.Objects;
import dan200.computercraft.api.lua.LuaException;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.reference.ConstantReference;

public class BlockReference
implements ConstantReference<BlockReference> {
    private final IWorldLocation location;
    private final WeakReference<TileEntity> tile;
    private final int tileHash;
    private final EnumFacing side;
    private IBlockState state;
    private boolean valid = true;

    public BlockReference(@Nonnull IWorldLocation location, @Nonnull IBlockState state, @Nullable TileEntity tile, @Nullable EnumFacing side) {
        this.location = location;
        this.tile = tile == null ? null : new WeakReference<TileEntity>(tile);
        this.tileHash = tile == null ? 0 : tile.hashCode();
        this.side = side;
        this.state = state;
    }

    public BlockReference(@Nonnull IWorldLocation location, @Nonnull IBlockState state, @Nullable TileEntity tile) {
        this(location, state, tile, null);
    }

    public BlockReference(@Nonnull IWorldLocation location, @Nullable EnumFacing side) {
        this(location, location.getWorld().func_180495_p(location.getPos()).func_185899_b((IBlockAccess)location.getWorld(), location.getPos()), location.getWorld().func_175625_s(location.getPos()), side);
    }

    public BlockReference(@Nonnull IWorldLocation location) {
        this(location, null);
    }

    @Override
    @Nonnull
    public BlockReference get() throws LuaException {
        World world = this.location.getWorld();
        BlockPos pos = this.location.getPos();
        IBlockState newState = world.func_180495_p(pos);
        TileEntity newTe = world.func_175625_s(pos);
        if (this.tile == null) {
            if (this.state.func_177230_c() != newState.func_177230_c()) {
                this.valid = false;
                throw new LuaException("The block is no longer there");
            }
            if (newTe != null) {
                this.valid = false;
                throw new LuaException("The block has changed");
            }
        } else {
            TileEntity oldTe = (TileEntity)this.tile.get();
            if (oldTe == null) {
                this.valid = false;
                throw new LuaException("The block is no longer there");
            }
            if (!oldTe.equals(newTe)) {
                this.valid = false;
                throw new LuaException("The block has changed");
            }
        }
        this.state = newState.func_185899_b((IBlockAccess)world, pos);
        this.valid = true;
        return this;
    }

    @Override
    @Nonnull
    public BlockReference safeGet() throws LuaException {
        TileEntity oldTe;
        if (!this.valid) {
            throw new LuaException("The block has changed");
        }
        if (this.tile != null && ((oldTe = (TileEntity)this.tile.get()) == null || oldTe.func_145837_r())) {
            throw new LuaException("The block has changed");
        }
        return this;
    }

    @Nonnull
    public IWorldLocation getLocation() {
        return this.location;
    }

    @Nonnull
    public IBlockState getState() {
        return this.state;
    }

    @Nullable
    public TileEntity getTileEntity() {
        return this.tile == null ? null : (TileEntity)this.tile.get();
    }

    @Nullable
    public EnumFacing getSide() {
        return this.side;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockReference that = (BlockReference)o;
        if (!this.location.equals(that.location) || this.tileHash != that.tileHash) {
            return false;
        }
        if (this.tile != that.tile) {
            TileEntity thatTile;
            if (this.tile == null) {
                return false;
            }
            TileEntity thisTile = (TileEntity)this.tile.get();
            TileEntity tileEntity = thatTile = that.tile == null ? null : (TileEntity)that.tile.get();
            if (!Objects.equal((Object)thisTile, (Object)thatTile)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.location.hashCode() + 31 * this.tileHash;
    }
}

