/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.Objects;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.IPeripheralHandler;
import org.squiddev.plethora.api.method.ICostHandler;
import org.squiddev.plethora.api.module.IModuleHandler;
import org.squiddev.plethora.api.vehicle.IVehicleUpgradeHandler;
import org.squiddev.plethora.core.CommandPlethora;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.MetaRegistry;
import org.squiddev.plethora.core.MethodRegistry;
import org.squiddev.plethora.core.MethodWrapperPeripheral;
import org.squiddev.plethora.core.ModuleRegistry;
import org.squiddev.plethora.core.PeripheralProvider;
import org.squiddev.plethora.core.Registry;
import org.squiddev.plethora.core.capabilities.DefaultCostHandler;
import org.squiddev.plethora.core.capabilities.DefaultModuleHandler;
import org.squiddev.plethora.core.capabilities.DefaultPeripheral;
import org.squiddev.plethora.core.capabilities.DefaultStorage;
import org.squiddev.plethora.core.capabilities.DefaultVehicleUpgradeHandler;
import org.squiddev.plethora.core.executor.TaskRunner;
import org.squiddev.plethora.core.wrapper.PlethoraMethodRegistry;
import org.squiddev.plethora.gameplay.PlethoraFakePlayer;
import org.squiddev.plethora.integration.vanilla.IntegrationVanilla;
import org.squiddev.plethora.utils.Helpers;

@Mod(modid="plethora-core", name="Plethora Core", version="1.2.3", dependencies="required-after:forge@[14.23.5.2768,);required-after:computercraft@[1.82.3,);required-after:cctweaked@[1.82.3,)", guiFactory="org.squiddev.plethora.core.client.gui.GuiConfigCore", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="plethora-core")
public class PlethoraCore {
    public static final String ID = "plethora-core";
    public static final String NAME = "Plethora Core";
    public static final String VERSION = "1.2.3";
    public static final String DEPENDENCIES = "required-after:forge@[14.23.5.2768,);required-after:computercraft@[1.82.3,);required-after:cctweaked@[1.82.3,)";
    public static final ResourceLocation PERIPHERAL_HANDLER_KEY = new ResourceLocation("plethora", "peripheralHandler");
    public static final Logger LOG = LogManager.getLogger((String)"plethora-core");
    private ASMDataTable asmData;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigCore.init(event.getSuggestedConfigurationFile());
        this.asmData = event.getAsmData();
        CapabilityManager.INSTANCE.register(ICostHandler.class, new DefaultStorage(), DefaultCostHandler::new);
        CapabilityManager.INSTANCE.register(IModuleHandler.class, new DefaultStorage(), DefaultModuleHandler::new);
        CapabilityManager.INSTANCE.register(IPeripheral.class, new DefaultStorage(), DefaultPeripheral::new);
        CapabilityManager.INSTANCE.register(IPeripheralHandler.class, new DefaultStorage(), DefaultPeripheral::new);
        CapabilityManager.INSTANCE.register(IVehicleUpgradeHandler.class, new DefaultStorage(), DefaultVehicleUpgradeHandler::new);
        ComputerCraftAPI.registerPeripheralProvider((world, pos, side) -> {
            TileEntity te = world.func_175625_s(pos);
            return te != null && te.hasCapability(Constants.PERIPHERAL_CAPABILITY, side) ? (IPeripheral)te.getCapability(Constants.PERIPHERAL_CAPABILITY, side) : null;
        });
        IntegrationVanilla.setup();
        FMLInterModComms.sendFunctionMessage((String)"xnet", (String)"getXNet", (String)"org.squiddev.plethora.integration.xnet.NetworkChannelType$Setup");
        FMLInterModComms.sendMessage((String)"opencomputers", (String)"blacklistPeripheral", (String)MethodWrapperPeripheral.class.getName());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Objects.requireNonNull(this.asmData, "asmData table cannot be null: this means preInit was not fired");
        long start = System.currentTimeMillis();
        Registry.register(this.asmData);
        PlethoraMethodRegistry.loadAsm(this.asmData);
        long finish = System.currentTimeMillis();
        LOG.info("Loaded {} methods and {} metadata providers in {} seconds", (Object)MethodRegistry.instance.providers.size(), (Object)MetaRegistry.instance.providers.size(), (Object)((double)(finish - start) * 0.001));
        ConfigCore.configuration.save();
    }

    @Mod.EventHandler
    public static void loadComplete(FMLLoadCompleteEvent event) {
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new PeripheralProvider());
    }

    @Mod.EventHandler
    public static void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandPlethora());
    }

    @Mod.EventHandler
    public static void onServerStart(FMLServerStartedEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            DefaultCostHandler.reset();
            TaskRunner.SHARED.reset();
        }
    }

    @Mod.EventHandler
    public static void onServerStopped(FMLServerStoppedEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            DefaultCostHandler.reset();
            TaskRunner.SHARED.reset();
        }
    }

    @Mod.EventHandler
    public static void onMessageReceived(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (!m.isStringMessage()) continue;
            if ("blacklistPeripheral".equalsIgnoreCase(m.key)) {
                LOG.debug("Blacklisting peripheral " + m.getStringValue() + " due to IMC from " + m.getSender());
                PeripheralProvider.addToBlacklist(m.getStringValue());
                continue;
            }
            if (!"blacklistMod".equalsIgnoreCase(m.key)) continue;
            LOG.debug("Blacklisting mod " + m.getStringValue() + " due to IMC from " + m.getSender());
            Helpers.blacklistMod(m.getStringValue());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            DefaultCostHandler.update();
            TaskRunner.SHARED.func_73660_a();
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(ID)) {
            ConfigCore.sync();
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModuleRegistry.instance.addRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof PlethoraFakePlayer)) {
            return;
        }
        event.setCanceled(true);
        event.getWorld().field_73010_i.remove(entity);
        LOG.error("Attempted to spawn PlethoraFakePlayer ({}). This should NEVER happen.", (Object)entity, (Object)new IllegalStateException("Stacktrace as follows:"));
    }
}

