/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.meta;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.utils.Helpers;
import org.squiddev.plethora.utils.WorldDummy;

@Injects
public final class MetaEntity
extends BaseMetaProvider<Entity> {
    public MetaEntity() {
        super("Provides some basic information about an entity, such as their their UUID and name.");
    }

    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IPartialContext<Entity> context) {
        Entity entity = context.getTarget();
        IWorldLocation location = context.getContext("origin", IWorldLocation.class);
        HashMap<String, Object> result = MetaEntity.getBasicProperties(entity, location);
        HashMap<String, Double> subBlock = new HashMap<String, Double>();
        result.put("withinBlock", subBlock);
        double posY = entity.field_70163_u + (double)entity.func_70047_e();
        subBlock.put("x", entity.field_70165_t - (double)MathHelper.func_76128_c((double)entity.field_70165_t));
        subBlock.put("y", posY - (double)MathHelper.func_76128_c((double)posY));
        subBlock.put("z", entity.field_70161_v - (double)MathHelper.func_76128_c((double)entity.field_70161_v));
        return result;
    }

    public static HashMap<String, Object> getBasicProperties(@Nonnull Entity entity, @Nullable IWorldLocation location) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", entity.func_110124_au().toString());
        result.put("name", Helpers.getName(entity));
        result.put("displayName", entity.func_70005_c_());
        result.put("motionX", entity.field_70159_w);
        result.put("motionY", entity.field_70181_x);
        result.put("motionZ", entity.field_70179_y);
        result.put("pitch", Float.valueOf(entity.field_70125_A));
        result.put("yaw", Float.valueOf(entity.field_70177_z));
        if (location != null && location.getWorld() == entity.func_130014_f_()) {
            Vec3d pos = location.getLoc();
            result.put("x", entity.field_70165_t - pos.field_72450_a);
            result.put("y", entity.field_70163_u + (double)entity.func_70047_e() - pos.field_72448_b);
            result.put("z", entity.field_70161_v - pos.field_72449_c);
        }
        return result;
    }

    @Override
    @Nonnull
    public Entity getExample() {
        EntityXPOrb entity = new EntityXPOrb((World)WorldDummy.INSTANCE);
        entity.func_70080_a(12.0, 0.0, 0.0, 30.0f, 73.0f);
        entity.field_70159_w = 0.5;
        entity.field_70181_x = 0.0;
        entity.field_70179_y = 0.0;
        return entity;
    }
}

