/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.method;

import dan200.computercraft.api.lua.LuaException;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.method.ArgumentHelper;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.reference.ItemSlot;

public final class MethodsInventoryWorld {
    private static final double SUCK_RADIUS = 1.0;

    private MethodsInventoryWorld() {
    }

    @PlethoraMethod(doc="-- Drop an item on the ground. Returns the number of items dropped")
    public static int drop(@FromTarget IItemHandler handler, @FromContext(value={"origin"}) IWorldLocation location, int slot, @Optional(defInt=0x7FFFFFFF) int limit, @Optional EnumFacing direction) throws LuaException {
        if (limit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        ArgumentHelper.assertBetween(slot, 1, handler.getSlots(), "Slot out of range (%s)");
        ItemStack stack = handler.extractItem(slot - 1, limit, false);
        return MethodsInventoryWorld.dropItem(location, stack, direction);
    }

    @PlethoraMethod(doc="-- Drop an item on the ground. Returns the number of items dropped")
    public static int drop(@FromTarget ItemSlot slot, @FromContext(value={"origin"}) IWorldLocation location, @Optional(defInt=0x7FFFFFFF) int limit, @Optional EnumFacing direction) throws LuaException {
        if (limit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        ItemStack stack = slot.extract(limit);
        return MethodsInventoryWorld.dropItem(location, stack, direction);
    }

    private static int dropItem(IWorldLocation location, @Nonnull ItemStack stack, EnumFacing direction) {
        if (stack.func_190926_b()) {
            return 0;
        }
        World world = location.getWorld();
        Vec3d pos = location.getLoc();
        if (direction != null) {
            pos = pos.func_178787_e(new Vec3d(direction.func_176730_m()).func_186678_a(0.75));
        }
        EntityItem entity = new EntityItem(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack.func_77946_l());
        entity.field_70159_w = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70179_y = 0.0;
        entity.func_174869_p();
        world.func_72838_d((Entity)entity);
        return stack.func_190916_E();
    }

    @PlethoraMethod(doc="-- Suck an item from the ground")
    public static int suck(@FromTarget IItemHandler handler, @FromContext(value={"origin"}) IWorldLocation location, @Optional int slot, @Optional(defInt=0x7FFFFFFF) int limit) throws LuaException {
        if (limit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        if (slot != -1) {
            ArgumentHelper.assertBetween(slot, 1, handler.getSlots(), "Slot out of range (%s)");
        }
        World world = location.getWorld();
        AxisAlignedBB box = location.getBounds().func_72314_b(1.0, 1.0, 1.0);
        int total = 0;
        int remaining = limit;
        for (EntityItem item : world.func_175647_a(EntityItem.class, box, EntitySelectors.field_94557_a)) {
            ItemStack original = item.func_92059_d();
            ItemStack toInsert = original.func_77946_l();
            if (toInsert.func_190916_E() > remaining) {
                toInsert.func_190920_e(remaining);
            }
            ItemStack rest = slot == -1 ? ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)toInsert, (boolean)false) : handler.insertItem(slot - 1, toInsert, false);
            int inserted = rest.func_190926_b() ? toInsert.func_190916_E() : toInsert.func_190916_E() - rest.func_190916_E();
            remaining -= inserted;
            total += inserted;
            if (inserted >= original.func_190916_E()) {
                item.func_70106_y();
            } else {
                original.func_190917_f(-inserted);
                item.func_92058_a(original);
            }
            if (remaining > 0) continue;
            break;
        }
        return total;
    }
}

