/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.gui.screen;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.astronomy.SpaceData;
import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.prefab.celestialbody.SpacePort;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import org.lwjgl.opengl.GL11;

public class Base_GuiCelestialSelection
extends GuiCelestialSelection {
    public static ResourceLocation guiMain2 = new ResourceLocation("asmodeuscore", "textures/gui/celestialselection2.png");
    protected EnumView viewState = EnumView.FULL;
    private String galaxy = BodiesRegistry.Galaxies.MILKYWAY.getName();
    private Set<String> galaxylist = new HashSet<String>();
    private Set<SolarSystem> starlist = new LinkedHashSet<SolarSystem>();
    private boolean showStarList = false;
    private boolean showGalaxyList = false;
    private boolean enableNewTierSystem = AsmodeusConfig.enableNewTierSystem;
    private double isometx = AsmodeusConfig.enable2DGalaxyMap ? 0.0 : 55.0;
    private double isometz = 45.0;
    private int small_page = 0;
    private double mindistance = 900.0;
    private int currenttier = 0;
    private int tierneed = -1;
    private int timer;
    private int traveltime;
    private boolean enableTraveltime = false;
    private int coef;
    private boolean canTravel = true;
    private SpaceData.Engine_Type engine = SpaceData.Engine_Type.FUEL_ENGINE;
    public static SpaceData data;
    protected static final int LIGHTBLUE;
    protected static final int YELLOW;

    public Base_GuiCelestialSelection(boolean mapMode, List<CelestialBody> possibleBodies, boolean canCreateStations, SpaceData data) {
        super(mapMode, possibleBodies, canCreateStations);
        Base_GuiCelestialSelection.data = data;
        if (Base_GuiCelestialSelection.data != null) {
            this.currenttier = (Integer)Base_GuiCelestialSelection.data.getValue("rocket_tier");
            this.engine = (SpaceData.Engine_Type)((Object)Base_GuiCelestialSelection.data.getValue("rocket_engine"));
        }
        this.coef = AsmodeusConfig.speedTimeTravel - 1 + this.currenttier;
        if (this.coef < 1) {
            this.coef = 1;
        }
        if (this.engine != null) {
            switch (this.engine) {
                case FUEL_ENGINE: {
                    break;
                }
                case ION_ENGINE: {
                    this.coef += 4;
                    break;
                }
                case PLASMA_ENGINE: {
                    this.coef += 8;
                    break;
                }
                case SUBLIGHT_ENGINE: {
                    this.coef += 100;
                    break;
                }
                case BLACKHOLE_ENGINE: {
                    this.coef += 1000;
                    break;
                }
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.bodiesToRender.clear();
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            if (!solarSystem.getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            this.bodiesToRender.add(solarSystem.getMainStar());
        }
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (!planet.getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            this.bodiesToRender.add(planet);
        }
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (!moon.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            this.bodiesToRender.add(moon);
        }
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (!satellite.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            this.bodiesToRender.add(satellite);
        }
        for (SpacePort spaceport : SpaceData.getRegisteredSpaceports().values()) {
            if (!spaceport.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            this.bodiesToRender.add(spaceport);
        }
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            this.galaxylist.add(solarSystem.getUnlocalizedParentGalaxyName());
            if (solarSystem.getUnlocalizedParentGalaxyName().equals(this.galaxy)) {
                this.starlist.add(solarSystem);
            }
            block6: for (SolarSystem star1 : GalaxyRegistry.getRegisteredSolarSystems().values()) {
                if (solarSystem == star1 || GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)star1).size() <= 0) continue;
                for (Planet planet : GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)star1)) {
                    if (!planet.getReachable()) continue;
                    double distance = solarSystem.getMapPosition().distance(star1.getMapPosition());
                    if (!(this.mindistance > distance) || !(distance > 600.0)) continue block6;
                    this.mindistance = distance;
                    continue block6;
                }
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void drawButtons(int mousePosX, int mousePosY) {
        int y;
        if (this.viewState == EnumView.DEFAULT) {
            super.drawButtons(mousePosX, mousePosY);
            return;
        }
        int LHS = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
        int RHS = this.field_146294_l - LHS;
        int TOP = LHS;
        int BOT = this.field_146295_m - LHS;
        this.field_73735_i = 0.0f;
        boolean handledSliderPos = false;
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(LHS, TOP, 74, 11, 0, 392, 148, 22, false, false);
        String str = GCCoreUtil.translate((String)"gui.message.catalog.name").toUpperCase();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(str, LHS + 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 1, WHITE);
        int scale = (int)Math.min(95.0f, (float)this.ticksSinceMenuOpen * 12.0f);
        boolean planetZoomedNotMoon = this.isZoomed() && !(this.selectedParent instanceof Planet);
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
        this.drawTexturedModalRect(LHS - 95 + scale, TOP + 12, 95, 41, 0, 436, 95, 41, false, false);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        if (GalaxyRegistry.getRegisteredSolarSystems().size() > 1) {
            this.drawTexturedModalRect(LHS + 2 - 13 + scale, TOP + 37, 5, 5, 110, 448, 5, 5, false, true);
        }
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        str = planetZoomedNotMoon ? this.selectedBody.getLocalizedName() : this.getParentName();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(str, LHS + 9 - 95 + scale, TOP + 34, YELLOW);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
        this.drawTexturedModalRect(LHS + 2 - 95 + scale, TOP + 14, 93, 17, 95, 436, 93, 17, false, false);
        if (this.galaxylist.size() > 1) {
            this.drawTexturedModalRect(LHS + 2 - 13 + scale, TOP + 19, 5, 5, 110, 448, 5, 5, false, true);
        }
        str = planetZoomedNotMoon ? this.getParentName() : this.getGrandparentName();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(str, LHS + 7 - 95 + scale, TOP + 16, LIGHTBLUE);
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        if (this.showGalaxyList) {
            int i = 0;
            for (String galaxy : this.galaxylist) {
                y = 19;
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)((float)scale / 95.0f));
                this.drawTexturedModalRect(LHS + 6 + scale, TOP + 14 * i + y, 86, 10, 0, 489, 86, 10, false, false);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)((float)scale / 95.0f));
                this.drawTexturedModalRect(LHS + 5 + scale, TOP + 14 * i + y - 1, 93, 12, 95, 464, 93, 12, false, false);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                str = GCCoreUtil.translate((String)galaxy);
                this.field_146289_q.func_78276_b(str, LHS + 10 + scale, TOP + 14 * i + y + 1, YELLOW);
                ++i;
            }
        }
        if (this.showStarList) {
            int l = 0;
            for (SolarSystem entry : this.starlist) {
                y = 19;
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)((float)scale / 95.0f));
                this.drawTexturedModalRect(LHS + 6 + scale, TOP + 14 * l + y, 86, 10, 0, 489, 86, 10, false, false);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)((float)scale / 95.0f));
                this.drawTexturedModalRect(LHS + 5 + scale, TOP + 14 * l + y - 1, 93, 12, 95, 464, 93, 12, false, false);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                str = entry.getMainStar().getLocalizedName();
                this.field_146289_q.func_78276_b(str, LHS + 10 + scale, TOP + 14 * l + y + 1, YELLOW);
                ++l;
            }
        }
        List children = this.getChildren(planetZoomedNotMoon ? this.selectedBody : this.selectedParent);
        this.drawChildren(children, 0, 0, true);
        if (this.mapMode) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            this.drawTexturedModalRect(RHS - 74, TOP, 74, 11, 0, 392, 148, 22, true, false);
            str = GCCoreUtil.translate((String)"gui.message.exit.name").toUpperCase();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146289_q.func_78276_b(str, RHS - 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 1, WHITE);
        }
        int menuTopLeft1 = BOT - 22;
        int posX1 = LHS - 53;
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
        this.drawTexturedModalRect(posX1 + 53, menuTopLeft1 - 5, 40, 12, 0, 456, 40, 12, false, false);
        this.drawTexturedModalRect(posX1 + 93, menuTopLeft1 - 5, 45, 12, 50, 456, 45, 12, false, false);
        str = this.viewState == EnumView.HIDE ? "Enable Info" : "Disable Info";
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(str, LHS + 15, menuTopLeft1 - 3, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
        this.drawTexturedModalRect(posX1 + 53, menuTopLeft1 - 19, 40, 12, 0, 456, 40, 12, false, false);
        this.drawTexturedModalRect(posX1 + 93, menuTopLeft1 - 19, 45, 12, 50, 456, 45, 12, false, false);
        str = this.viewState == EnumView.SMALL ? "Small Mode" : "Normal Mode";
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(str, LHS + 15, menuTopLeft1 - 17, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
        if (this.selectedBody != null) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            if (this.selectedBody instanceof Satellite) {
                Satellite selectedSatellite = (Satellite)this.selectedBody;
                int stationListSize = ((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).size();
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                int max = Math.min(this.field_146295_m / 2 / 14, stationListSize);
                this.drawTexturedModalRect(RHS - 95, TOP, 95, 53, this.selectedStationOwner.length() == 0 ? 95 : 0, 186, 95, 53, false, false);
                if (this.spaceStationListOffset <= 0) {
                    GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                }
                this.drawTexturedModalRect(RHS - 85, TOP + 45, 61, 4, 0, 239, 61, 4, false, false);
                if (max + this.spaceStationListOffset >= stationListSize) {
                    GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                }
                this.drawTexturedModalRect(RHS - 85, TOP + 49 + max * 14, 61, 4, 0, 239, 61, 4, false, true);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                if (((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(this.selectedStationOwner) == null) {
                    str = GCCoreUtil.translate((String)"gui.message.select_ss.name");
                    this.drawSplitString(str, RHS - 47, TOP + 20, 91, WHITE, false, false);
                } else {
                    str = GCCoreUtil.translate((String)"gui.message.ss_owner.name");
                    this.field_146289_q.func_78276_b(str, RHS - 85, TOP + 18, WHITE);
                    str = this.selectedStationOwner;
                    this.field_146289_q.func_78276_b(str, RHS - 47 - this.field_146289_q.func_78256_a(str) / 2, TOP + 30, WHITE);
                }
                Iterator it = ((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).entrySet().iterator();
                int i = 0;
                int j = 0;
                while (it.hasNext() && i < max) {
                    Map.Entry e = it.next();
                    if (j >= this.spaceStationListOffset) {
                        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                        int xOffset = 0;
                        if (((String)e.getKey()).equalsIgnoreCase(this.selectedStationOwner)) {
                            xOffset -= 5;
                        }
                        this.drawTexturedModalRect(RHS - 95 + xOffset, TOP + 50 + i * 14, 93, 12, 95, 464, 93, 12, true, false);
                        str = "";
                        String str0 = ((GuiCelestialSelection.StationDataGUI)e.getValue()).getStationName();
                        for (int point = 0; this.field_146289_q.func_78256_a(str) < 80 && point < str0.length(); ++point) {
                            str = str + str0.substring(point, point + 1);
                        }
                        if (this.field_146289_q.func_78256_a(str) >= 80) {
                            str = str.substring(0, str.length() - 3);
                            str = str + "...";
                        }
                        this.field_146289_q.func_78276_b(str, RHS - 88 + xOffset, TOP + 52 + i * 14, WHITE);
                        ++i;
                    }
                    ++j;
                }
            } else if (this.viewState != EnumView.HIDE) {
                this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                y = 100;
                int sliderPos = this.zoomTooltipPos;
                if (this.zoomTooltipPos != 125) {
                    this.zoomTooltipPos = sliderPos = Math.min(this.ticksSinceSelection * 8, 125);
                }
                int menuTopLeft = LHS + y;
                int posX = RHS - sliderPos;
                int posX2 = RHS - 18;
                if (this.selectedBody instanceof Star || this.selectedBody.getTierRequirement() < 0) {
                    this.drawTexturedModalRect(posX - 7, menuTopLeft + 12, 133, 31, 0, 79, 266, 62, true, false);
                    this.drawTexturedModalRect(posX - 7, menuTopLeft + 43, 133, 37, 0, 442, 266, 70, true, false);
                } else if (this.viewState != EnumView.SMALL) {
                    this.drawTexturedModalRect(posX - 7, menuTopLeft + 13, 133, 237, 0, 79, 266, 433, true, false);
                } else {
                    this.drawTexturedModalRect(posX - 7, menuTopLeft + 13, 133, 80, 0, 79, 266, 142, true, false);
                    this.drawTexturedModalRect(posX - 7, menuTopLeft + 93, 133, 17, 0, 472, 266, 40, true, false);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    this.drawTexturedModalRect(posX + 5, menuTopLeft + 112, 30, 11, 0, 414, 60, 22, false, false);
                    this.drawTexturedModalRect(posX + 35, menuTopLeft + 112, 50, 11, 128, 414, 40, 22, false, false);
                    this.drawTexturedModalRect(posX + 85, menuTopLeft + 112, 30, 11, 128, 414, 60, 22, false, false);
                    this.field_146289_q.func_78276_b("<-", posX + 13, menuTopLeft + 114, CYAN);
                    this.field_146289_q.func_78276_b("Page: " + (this.small_page + 1), posX + 45, menuTopLeft + 114, CYAN);
                    this.field_146289_q.func_78276_b("->", posX + 100, menuTopLeft + 114, CYAN);
                    this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
                }
                this.getInfo(posX, TOP + y);
            }
        }
    }

    private void getInfo(int x, int y) {
        Object curplanet;
        y += 15;
        String str = GCCoreUtil.translate((String)"gui.message.generalinformation");
        if (this.viewState != EnumView.SMALL) {
            this.field_146289_q.func_78276_b(str, x, y, CYAN);
        } else if (this.small_page == 0 || this.selectedBody instanceof Star) {
            this.field_146289_q.func_78276_b(str, x, y, CYAN);
        }
        if (this.selectedBody instanceof Star || this.selectedBody.getTierRequirement() == -1) {
            str = GCCoreUtil.translate((String)"gui.message.type") + " " + GCCoreUtil.translate((String)"gui.message.star");
        }
        if (this.selectedBody instanceof Planet && this.selectedBody.getTierRequirement() != -1) {
            str = GCCoreUtil.translate((String)"gui.message.type") + " " + GCCoreUtil.translate((String)"gui.message.planet");
        }
        if (this.selectedBody instanceof Moon) {
            str = GCCoreUtil.translate((String)"gui.message.type") + " " + GCCoreUtil.translate((String)"gui.message.moon");
        }
        if (this.selectedBody instanceof Satellite) {
            str = GCCoreUtil.translate((String)"gui.message.type") + " " + GCCoreUtil.translate((String)"gui.message.satellite");
        }
        if (this.selectedBody.getTierRequirement() == -2) {
            str = GCCoreUtil.translate((String)"gui.message.type") + " " + GCCoreUtil.translate((String)"gui.info.blackhole.name");
        }
        if (this.viewState != EnumView.SMALL) {
            this.field_146289_q.func_78276_b(str, x, y + 10, WHITE);
        } else if (this.small_page == 0 || this.selectedBody instanceof Star) {
            this.field_146289_q.func_78276_b(str, x, y + 10, WHITE);
        }
        WorldProvider dim = WorldUtil.getProviderForDimensionClient((int)this.selectedBody.getDimensionID());
        if (dim instanceof IGalacticraftWorldProvider) {
            if (((IGalacticraftWorldProvider)dim).getCelestialBody() instanceof Planet) {
                curplanet = (Planet)((IGalacticraftWorldProvider)dim).getCelestialBody();
                this.galaxy = curplanet.getParentSolarSystem().getUnlocalizedParentGalaxyName();
            } else if (((IGalacticraftWorldProvider)dim).getCelestialBody() instanceof IChildBody) {
                curplanet = (IChildBody)((IGalacticraftWorldProvider)dim).getCelestialBody();
                this.galaxy = curplanet.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName();
            }
        }
        str = GCCoreUtil.translate((String)"gui.message.class") + " " + BodiesRegistry.classPlanet(this.selectedBody, dim);
        if (this.viewState != EnumView.SMALL) {
            this.field_146289_q.func_78276_b(str, x, y + 20, WHITE);
        } else if (this.small_page == 0 || this.selectedBody instanceof Star) {
            this.field_146289_q.func_78276_b(str, x, y + 20, WHITE);
        }
        if (this.selectedBody.getTierRequirement() != -1 && !(this.selectedBody instanceof Star)) {
            str = GCCoreUtil.translate((String)"gui.message.physicalparameters");
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 40, CYAN);
            } else if (this.small_page == 0) {
                this.field_146289_q.func_78276_b(str, x, y + 40, CYAN);
            }
            str = GCCoreUtil.translate((String)"gui.message.atmosphericparameters");
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 82, CYAN);
            } else if (this.small_page == 1) {
                this.field_146289_q.func_78276_b(str, x, y, CYAN);
            }
            str = GCCoreUtil.translate((String)"gui.message.atmosphericcomponents");
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 166, CYAN);
            } else if (this.small_page == 2) {
                this.field_146289_q.func_78276_b(str, x, y, CYAN);
            }
            str = GCCoreUtil.translate((String)"gui.message.hasdungeons") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.hasdungeons") + " " + this.localeBoolean(((IGalacticraftWorldProvider)dim).getDungeonChestType() != null);
            }
            if (this.selectedBody == GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.hasdungeons") + " " + this.localeBoolean(true);
            }
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 29, WHITE);
            } else if (this.small_page == 0) {
                this.field_146289_q.func_78276_b(str, x, y + 29, WHITE);
            }
            str = GCCoreUtil.translate((String)"gui.message.gravity") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.gravity") + " " + ((IGalacticraftWorldProvider)dim).getGravity() + " G";
            } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.gravity") + " " + 0.085 + " G";
            }
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 38 + 12, WHITE);
            } else if (this.small_page == 0) {
                this.field_146289_q.func_78276_b(str, x, y + 38 + 12, WHITE);
            }
            str = GCCoreUtil.translate((String)"gui.message.daylength") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.daylength") + " " + ((WorldProviderSpace)dim).getDayLength() / 1000L + ":" + ((WorldProviderSpace)dim).getDayLength() % 1000L + "";
            } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.daylength") + " 24:0h";
            }
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 38 + 22, WHITE);
            } else if (this.small_page == 0) {
                this.field_146289_q.func_78276_b(str, x, y + 38 + 22, WHITE);
            }
            str = GCCoreUtil.translate((String)"gui.message.atmopressure") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
            if (BodiesRegistry.getData().get(this.selectedBody) != null) {
                curplanet = BodiesRegistry.getData().get(this.selectedBody);
            } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.atmopressure") + " P 1";
            }
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 78 + 14, WHITE);
            } else if (this.small_page == 1) {
                this.field_146289_q.func_78276_b(str, x, y + 10, WHITE);
            }
            str = GCCoreUtil.translate((String)"gui.message.temperature") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
            float temp = 0.0f;
            try {
                temp = ((IGalacticraftWorldProvider)dim).getThermalLevelModifier();
            }
            catch (Exception exception) {
                // empty catch block
            }
            float f = temp = temp == 0.0f ? 40.0f : temp * 40.0f;
            if (this.selectedBody.getReachable()) {
                str = GCCoreUtil.translate((String)"gui.message.temperature") + " " + temp + " C";
            }
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 78 + 24, WHITE);
            } else if (this.small_page == 1) {
                this.field_146289_q.func_78276_b(str, x, y + 20, WHITE);
            }
            str = GCCoreUtil.translate((String)"gui.message.windenergy") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld && dim instanceof IAdvancedSpace) {
                str = GCCoreUtil.translate((String)"gui.message.windenergy") + " " + (float)Math.round(((IAdvancedSpace)dim).getSolarWindMultiplier() * 1000.0) / 1000.0f;
            } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.windenergy") + " " + 1.0;
            }
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 76 + 36, WHITE);
            } else if (this.small_page == 1) {
                this.field_146289_q.func_78276_b(str, x, y + 30, WHITE);
            }
            str = GCCoreUtil.translate((String)"gui.message.solarenergy") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
            if (dim instanceof ISolarLevel) {
                float boost = (float)Math.round((((ISolarLevel)dim).getSolarEnergyMultiplier() - 1.0) * 1000.0) / 10.0f;
                str = GCCoreUtil.translate((String)"gui.message.solarenergy") + " " + boost + "%";
            }
            if (this.selectedBody == GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.solarenergy") + " 100%";
            }
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 76 + 48, WHITE);
            } else if (this.small_page == 1) {
                this.field_146289_q.func_78276_b(str, x, y + 40, WHITE);
            }
            str = GCCoreUtil.translate((String)"gui.message.windspeed") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
            if (dim instanceof IGalacticraftWorldProvider) {
                str = GCCoreUtil.translate((String)"gui.message.windspeed") + " " + ((IGalacticraftWorldProvider)dim).getWindLevel() + " W/l";
            }
            if (this.selectedBody == GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.windspeed") + " 1.0 W/l";
            }
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 74 + 60, WHITE);
            } else if (this.small_page == 1) {
                this.field_146289_q.func_78276_b(str, x, y + 50, WHITE);
            }
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 78 + 66, WHITE);
            } else if (this.small_page == 1) {
                this.field_146289_q.func_78276_b(str, x, y + 60, WHITE);
            }
            str = GCCoreUtil.translate((String)"gui.message.breathableatmo") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.breathableatmo") + " " + this.localeBoolean(this.selectedBody.atmosphere.isBreathable());
            }
            if (this.selectedBody == GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.breathableatmo") + " " + this.localeBoolean(true);
            }
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 77 + 99, WHITE);
            } else if (this.small_page == 2) {
                this.field_146289_q.func_78276_b(str, x, y + 10, WHITE);
            }
            str = GCCoreUtil.translate((String)"gui.message.corrosiveatmo") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.corrosiveatmo") + " " + this.localeBoolean(this.selectedBody.atmosphere.isCorrosive());
            }
            if (this.selectedBody == GalacticraftCore.planetOverworld) {
                str = GCCoreUtil.translate((String)"gui.message.corrosiveatmo") + " " + this.localeBoolean(false);
            }
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 76 + 110, WHITE);
            } else if (this.small_page == 2) {
                this.field_146289_q.func_78276_b(str, x, y + 20, WHITE);
            }
            str = this.selectedBody.getReachable() && !this.selectedBody.atmosphere.hasNoGases() ? this.selectedBody.atmosphere.composition.toString() : GCCoreUtil.translate((String)"gui.message.noatmosphere");
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 75 + 121, WHITE);
            } else if (this.small_page == 2) {
                this.field_146289_q.func_78276_b(str, x, y + 30, WHITE);
            }
            String travel = this.traveltime / 100 + "h " + this.traveltime % 100 + "m";
            str = GCCoreUtil.translate((String)"gui.message.traveltime") + " " + travel;
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 79 + 143, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
            } else if (this.small_page == 2) {
                this.field_146289_q.func_78276_b(str, x, y + 80, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
            }
        }
        if (this.selectedBody instanceof Star) {
            int planets = 0;
            for (CelestialBody body : this.getChildren(this.selectedParent)) {
                if (body.getTierRequirement() < 0) continue;
                ++planets;
            }
            str = GCCoreUtil.translate((String)"gui.message.planets") + " " + planets;
            this.field_146289_q.func_78276_b(str, x, y + 29 + 11, WHITE);
        } else if (this.selectedBody instanceof Planet && this.selectedBody.getTierRequirement() != -1) {
            str = GCCoreUtil.translate((String)"gui.message.moons") + " " + this.getChildren(this.selectedBody).size();
            if (this.viewState != EnumView.SMALL) {
                this.field_146289_q.func_78276_b(str, x, y + 78 + 132, WHITE);
            } else if (this.small_page == 2) {
                this.field_146289_q.func_78276_b(str, x, y + 70, WHITE);
            }
        }
    }

    private int calculateDistance() {
        int get_distance = 0;
        int travel_modifier = 200;
        double idcel = 0.0;
        double dist = 0.0;
        SolarSystem cur_system = GalacticraftCore.solarSystemSol;
        double time = 0.0;
        if (this.selectedBody != null) {
            idcel = GalacticraftCore.planetOverworld.getRelativeDistanceFromCenter().unScaledDistance;
            dist = Math.abs(Math.floor((idcel - (double)this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance) * 100.0)) / 100.0;
            if (!(this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof WorldProviderSurface) && this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
                CelestialBody body = ((IGalacticraftWorldProvider)this.field_146297_k.field_71439_g.field_70170_p.field_73011_w).getCelestialBody();
                if (body instanceof Planet) {
                    cur_system = ((Planet)body).getParentSolarSystem();
                    idcel = body.getRelativeDistanceFromCenter().unScaledDistance;
                } else if (body instanceof IChildBody) {
                    cur_system = ((IChildBody)body).getParentPlanet().getParentSolarSystem();
                    idcel = ((IChildBody)body).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance;
                }
                dist = Math.abs(Math.floor((idcel - (double)this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance) * 100.0)) / 100.0;
            }
        }
        return get_distance;
    }

    private String localeBoolean(boolean bol) {
        return bol ? GCCoreUtil.translate((String)"gui.message.yes") : GCCoreUtil.translate((String)"gui.message.no");
    }

    static {
        LIGHTBLUE = ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)255);
        YELLOW = ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0);
    }

    protected static enum EnumView {
        DEFAULT,
        FULL,
        SMALL,
        HIDE;

    }
}

