/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import openblocks.common.TrophyHandler;
import openmods.item.ItemOpenBlock;
import openmods.utils.ItemUtils;
import openmods.utils.TranslationUtils;

public class ItemTrophyBlock
extends ItemOpenBlock {
    private static final String TAG_ENTITY = "entity";
    private static final String TAG_ENTITY_ID = "entity_id";

    public ItemTrophyBlock(Block block) {
        super(block);
    }

    public static TrophyHandler.Trophy getTrophy(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_150297_b(TAG_ENTITY_ID, 8)) {
                ResourceLocation id = new ResourceLocation(tag.func_74779_i(TAG_ENTITY_ID));
                return TrophyHandler.Trophy.TYPES_BY_ID.get(id);
            }
            if (tag.func_74764_b(TAG_ENTITY)) {
                String entityKey = tag.func_74779_i(TAG_ENTITY);
                return TrophyHandler.Trophy.TYPES_BY_NAME.get(entityKey);
            }
        }
        return null;
    }

    public int getMetadata(@Nonnull ItemStack stack) {
        TrophyHandler.Trophy trophy = ItemTrophyBlock.getTrophy(stack);
        return trophy != null ? trophy.ordinal() : 0;
    }

    public static ItemStack putMetadata(@Nonnull ItemStack stack, TrophyHandler.Trophy trophy) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74778_a(TAG_ENTITY_ID, trophy.id.toString());
        return stack;
    }

    public String func_77653_i(@Nonnull ItemStack stack) {
        TrophyHandler.Trophy trophyType = ItemTrophyBlock.getTrophy(stack);
        if (trophyType != null) {
            String name = TranslationUtils.translateToLocal((String)trophyType.translationKey());
            return TranslationUtils.translateToLocalFormatted((String)(super.func_77658_a() + ".entity.name"), (Object[])new Object[]{name});
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> result) {
        if (this.func_194125_a(tab)) {
            for (TrophyHandler.Trophy trophy : TrophyHandler.Trophy.VALUES) {
                result.add((Object)ItemTrophyBlock.putMetadata(new ItemStack((Item)this), trophy));
            }
        }
    }
}

