/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.delegates.misc;

import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.api.ActionLogger;
import me.lucko.luckperms.api.Log;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.api.delegates.model.ApiLog;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiActionLogger
implements ActionLogger {
    private final LuckPermsPlugin plugin;

    public ApiActionLogger(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public @NonNull LogEntry.Builder newEntryBuilder() {
        return ExtendedLogEntry.build();
    }

    @Override
    public @NonNull CompletableFuture<Log> getLog() {
        return this.plugin.getStorage().getLog().thenApply(ApiLog::new);
    }

    @Override
    public @NonNull CompletableFuture<Void> submit(@NonNull LogEntry entry) {
        return CompletableFuture.runAsync(() -> this.plugin.getLogDispatcher().dispatchFromApi((ExtendedLogEntry)entry), this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public @NonNull CompletableFuture<Void> submitToStorage(@NonNull LogEntry entry) {
        return this.plugin.getStorage().logAction(entry);
    }

    @Override
    public @NonNull CompletableFuture<Void> broadcastAction(@NonNull LogEntry entry) {
        return CompletableFuture.runAsync(() -> this.plugin.getLogDispatcher().broadcastFromApi((ExtendedLogEntry)entry), this.plugin.getBootstrap().getScheduler().async());
    }
}

