/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.commands.group.CreateGroup;
import me.lucko.luckperms.common.commands.group.DeleteGroup;
import me.lucko.luckperms.common.commands.group.GroupMainCommand;
import me.lucko.luckperms.common.commands.group.ListGroups;
import me.lucko.luckperms.common.commands.log.LogMainCommand;
import me.lucko.luckperms.common.commands.migration.MigrationMainCommand;
import me.lucko.luckperms.common.commands.misc.ApplyEditsCommand;
import me.lucko.luckperms.common.commands.misc.BulkUpdateCommand;
import me.lucko.luckperms.common.commands.misc.CheckCommand;
import me.lucko.luckperms.common.commands.misc.DebugCommand;
import me.lucko.luckperms.common.commands.misc.EditorCommand;
import me.lucko.luckperms.common.commands.misc.ExportCommand;
import me.lucko.luckperms.common.commands.misc.ImportCommand;
import me.lucko.luckperms.common.commands.misc.InfoCommand;
import me.lucko.luckperms.common.commands.misc.NetworkSyncCommand;
import me.lucko.luckperms.common.commands.misc.ReloadConfigCommand;
import me.lucko.luckperms.common.commands.misc.SearchCommand;
import me.lucko.luckperms.common.commands.misc.SyncCommand;
import me.lucko.luckperms.common.commands.misc.TreeCommand;
import me.lucko.luckperms.common.commands.misc.VerboseCommand;
import me.lucko.luckperms.common.commands.track.CreateTrack;
import me.lucko.luckperms.common.commands.track.DeleteTrack;
import me.lucko.luckperms.common.commands.track.ListTracks;
import me.lucko.luckperms.common.commands.track.TrackMainCommand;
import me.lucko.luckperms.common.commands.user.UserMainCommand;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.TextUtils;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;

public class CommandManager {
    public static final Pattern COMMAND_SEPARATOR_PATTERN = Pattern.compile(" (?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)");
    public static final UUID CONSOLE_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static final String CONSOLE_NAME = "Console";
    public static final UUID IMPORT_UUID = UUID.fromString("11111111-1111-1111-1111-111111111111");
    public static final String IMPORT_NAME = "Import";
    public static final char SECTION_CHAR = '\u00a7';
    public static final char AMPERSAND_CHAR = '&';
    private final LuckPermsPlugin plugin;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final TabCompletions tabCompletions;
    private final List<Command<?, ?>> mainCommands;

    public CommandManager(LuckPermsPlugin plugin) {
        this.plugin = plugin;
        LocaleManager locale = plugin.getLocaleManager();
        this.tabCompletions = new TabCompletions(plugin);
        this.mainCommands = ImmutableList.builder().add((Object)new UserMainCommand(locale)).add((Object)new GroupMainCommand(locale)).add((Object)new TrackMainCommand(locale)).addAll(plugin.getExtraCommands()).add((Object)new LogMainCommand(locale)).add((Object)new SyncCommand(locale)).add((Object)new InfoCommand(locale)).add((Object)new EditorCommand(locale)).add((Object)new DebugCommand(locale)).add((Object)new VerboseCommand(locale)).add((Object)new TreeCommand(locale)).add((Object)new SearchCommand(locale)).add((Object)new CheckCommand(locale)).add((Object)new NetworkSyncCommand(locale)).add((Object)new ImportCommand(locale)).add((Object)new ExportCommand(locale)).add((Object)new ReloadConfigCommand(locale)).add((Object)new BulkUpdateCommand(locale)).add((Object)new MigrationMainCommand(locale)).add((Object)new ApplyEditsCommand(locale)).add((Object)new CreateGroup(locale)).add((Object)new DeleteGroup(locale)).add((Object)new ListGroups(locale)).add((Object)new CreateTrack(locale)).add((Object)new DeleteTrack(locale)).add((Object)new ListTracks(locale)).build();
    }

    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    public TabCompletions getTabCompletions() {
        return this.tabCompletions;
    }

    public CompletableFuture<CommandResult> onCommand(Sender sender, String label, List<String> args) {
        return this.onCommand(sender, label, args, this.executor);
    }

    public CompletableFuture<CommandResult> onCommand(Sender sender, String label, List<String> args, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.execute(sender, label, args);
            }
            catch (Throwable e) {
                this.plugin.getLogger().severe("Exception whilst executing command: " + args.toString());
                e.printStackTrace();
                return null;
            }
        }, executor);
    }

    private CommandResult execute(Sender sender, String label, List<String> args) {
        CommandResult result;
        ArrayList<String> arguments = new ArrayList<String>(args);
        CommandManager.handleRewrites(arguments, true);
        if (arguments.isEmpty() || arguments.size() == 1 && ((String)arguments.get(0)).trim().isEmpty()) {
            MessageUtils.sendPluginMessage(sender, "&2Running &bLuckPerms v" + this.plugin.getBootstrap().getVersion() + "&2.");
            if (this.mainCommands.stream().anyMatch(c -> c.shouldDisplay() && c.isAuthorized(sender))) {
                Message.VIEW_AVAILABLE_COMMANDS_PROMPT.send(sender, label);
            } else {
                Collection groups = this.plugin.getGroupManager().getAll().values();
                if (groups.size() <= 1 && groups.stream().allMatch(g -> g.getOwnNodes().isEmpty())) {
                    Message.FIRST_TIME_SETUP.send(sender, label, sender.getName());
                } else {
                    Message.NO_PERMISSION_FOR_SUBCOMMANDS.send(sender, new Object[0]);
                }
            }
            return CommandResult.INVALID_ARGS;
        }
        Optional<Command> o = this.mainCommands.stream().filter(m -> m.getName().equalsIgnoreCase((String)arguments.get(0))).limit(1L).findAny();
        if (!o.isPresent()) {
            this.sendCommandUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        Command main = o.get();
        if (!main.isAuthorized(sender)) {
            this.sendCommandUsage(sender, label);
            return CommandResult.NO_PERMISSION;
        }
        arguments.remove(0);
        if (main.getArgumentCheck().test(arguments.size())) {
            main.sendDetailedUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        try {
            result = main.execute(this.plugin, sender, null, arguments, label);
        }
        catch (CommandException e) {
            result = CommandManager.handleException(e, sender, label, main);
        }
        catch (Throwable e) {
            e.printStackTrace();
            result = CommandResult.FAILURE;
        }
        return result;
    }

    public List<String> onTabComplete(Sender sender, List<String> args) {
        ArrayList<String> arguments = new ArrayList<String>(args);
        CommandManager.handleRewrites(arguments, false);
        List mains = this.mainCommands.stream().filter(Command::shouldDisplay).filter(m -> m.isAuthorized(sender)).collect(Collectors.toList());
        if (arguments.size() <= 1) {
            if (arguments.isEmpty() || ((String)arguments.get(0)).equals("")) {
                return mains.stream().map(m -> m.getName().toLowerCase()).collect(Collectors.toList());
            }
            return mains.stream().map(m -> m.getName().toLowerCase()).filter(s -> s.startsWith(((String)arguments.get(0)).toLowerCase())).collect(Collectors.toList());
        }
        Optional<Command> o = mains.stream().filter(m -> m.getName().equalsIgnoreCase((String)arguments.get(0))).findFirst();
        arguments.remove(0);
        return o.map(cmd -> cmd.tabComplete(this.plugin, sender, arguments)).orElseGet(Collections::emptyList);
    }

    private void sendCommandUsage(Sender sender, String label) {
        MessageUtils.sendPluginMessage(sender, "&2Running &bLuckPerms v" + this.plugin.getBootstrap().getVersion() + "&2.");
        this.mainCommands.stream().filter(Command::shouldDisplay).filter(c -> c.isAuthorized(sender)).forEach(c -> {
            String permission = c.getPermission().map(CommandPermission::getPermission).orElse("None");
            TextComponent component = ((TextComponent.Builder)TextUtils.fromLegacy("&3> &a" + String.format(c.getUsage(), label), '&').toBuilder().applyDeep(comp -> {
                comp.hoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Component)TextUtils.fromLegacy(TextUtils.joinNewline("&bCommand: &2" + c.getName(), "&bDescription: &2" + c.getDescription(), "&bUsage: &2" + String.format(c.getUsage(), label), "&bPermission: &2" + permission, " ", "&7Click to auto-complete."), '&')));
                comp.clickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format(c.getUsage(), label)));
            })).build();
            sender.sendMessage((Component)component);
        });
    }

    public static CommandResult handleException(CommandException e, Sender sender, String label, Command command) {
        if (e instanceof ArgumentParser.ArgumentException) {
            if (e instanceof ArgumentParser.DetailedUsageException) {
                command.sendDetailedUsage(sender, label);
                return CommandResult.INVALID_ARGS;
            }
            if (e instanceof ArgumentParser.InvalidServerWorldException) {
                Message.SERVER_WORLD_INVALID_ENTRY.send(sender, new Object[0]);
                return CommandResult.INVALID_ARGS;
            }
            if (e instanceof ArgumentParser.PastDateException) {
                Message.PAST_DATE_ERROR.send(sender, new Object[0]);
                return CommandResult.INVALID_ARGS;
            }
            if (e instanceof ArgumentParser.InvalidDateException) {
                Message.ILLEGAL_DATE_ERROR.send(sender, ((ArgumentParser.InvalidDateException)e).getInvalidDate());
                return CommandResult.INVALID_ARGS;
            }
            if (e instanceof ArgumentParser.InvalidPriorityException) {
                Message.META_INVALID_PRIORITY.send(sender, ((ArgumentParser.InvalidPriorityException)e).getInvalidPriority());
                return CommandResult.INVALID_ARGS;
            }
        }
        e.printStackTrace();
        return CommandResult.FAILURE;
    }

    private static void handleRewrites(List<String> args, boolean rewriteLastArgument) {
        if (args.size() >= 1 && (rewriteLastArgument || args.size() >= 2)) {
            String arg0 = args.get(0);
            if (arg0.equalsIgnoreCase("u") || arg0.equalsIgnoreCase("player") || arg0.equalsIgnoreCase("p")) {
                args.remove(0);
                args.add(0, "user");
            } else if (arg0.equalsIgnoreCase("g")) {
                args.remove(0);
                args.add(0, "group");
            } else if (arg0.equalsIgnoreCase("t")) {
                args.remove(0);
                args.add(0, "track");
            } else if (arg0.equalsIgnoreCase("i")) {
                args.remove(0);
                args.add(0, "info");
            }
        }
        if (args.size() >= 3 && (rewriteLastArgument || args.size() >= 4)) {
            boolean lazySet;
            boolean lazyInfo;
            String s;
            if (!args.get(0).equalsIgnoreCase("user") && !args.get(0).equalsIgnoreCase("group")) {
                return;
            }
            switch (s = args.get(2).toLowerCase()) {
                case "p": 
                case "perm": 
                case "perms": {
                    args.remove(2);
                    args.add(2, "permission");
                    break;
                }
                case "chat": 
                case "m": {
                    args.remove(2);
                    args.add(2, "meta");
                    break;
                }
                case "i": 
                case "about": 
                case "list": {
                    args.remove(2);
                    args.add(2, "info");
                    break;
                }
                case "inherit": 
                case "inheritances": 
                case "group": 
                case "groups": 
                case "g": 
                case "rank": 
                case "ranks": 
                case "parents": {
                    args.remove(2);
                    args.add(2, "parent");
                    break;
                }
                case "e": {
                    args.remove(2);
                    args.add(2, "editor");
                    break;
                }
                case "setprimarygroup": 
                case "switchprimarygroup": {
                    args.remove(2);
                    args.add(2, "parent");
                    args.add(3, "switchprimarygroup");
                    break;
                }
                case "listnodes": {
                    args.remove(2);
                    args.add(2, "permission");
                    args.add(3, "info");
                    break;
                }
                case "set": 
                case "unset": 
                case "settemp": 
                case "unsettemp": {
                    args.add(2, "permission");
                    break;
                }
                case "haspermission": {
                    args.remove(2);
                    args.add(2, "permission");
                    args.add(3, "check");
                    break;
                }
                case "inheritspermission": {
                    args.remove(2);
                    args.add(2, "permission");
                    args.add(3, "checkinherits");
                    break;
                }
                case "listgroups": {
                    args.remove(2);
                    args.add(2, "parent");
                    args.add(3, "info");
                    break;
                }
                case "addgroup": 
                case "setinherit": {
                    args.remove(2);
                    args.add(2, "parent");
                    args.add(3, "add");
                    break;
                }
                case "setgroup": {
                    args.remove(2);
                    args.add(2, "parent");
                    args.add(3, "set");
                    break;
                }
                case "removegroup": 
                case "unsetinherit": {
                    args.remove(2);
                    args.add(2, "parent");
                    args.add(3, "remove");
                    break;
                }
                case "addtempgroup": 
                case "settempinherit": {
                    args.remove(2);
                    args.add(2, "parent");
                    args.add(3, "addtemp");
                    break;
                }
                case "removetempgroup": 
                case "unsettempinherit": {
                    args.remove(2);
                    args.add(2, "parent");
                    args.add(3, "removetemp");
                    break;
                }
                case "chatmeta": {
                    args.remove(2);
                    args.add(2, "meta");
                    args.add(3, "info");
                    break;
                }
                case "addprefix": 
                case "addsuffix": 
                case "removeprefix": 
                case "removesuffix": 
                case "addtempprefix": 
                case "addtempsuffix": 
                case "removetempprefix": 
                case "removetempsuffix": {
                    args.add(2, "meta");
                    break;
                }
            }
            boolean bl = lazyInfo = !(args.size() < 4 || !rewriteLastArgument && args.size() < 5 || !args.get(2).equalsIgnoreCase("permission") && !args.get(2).equalsIgnoreCase("parent") && !args.get(2).equalsIgnoreCase("meta") || !args.get(3).equalsIgnoreCase("i") && !args.get(3).equalsIgnoreCase("about") && !args.get(3).equalsIgnoreCase("list"));
            if (lazyInfo) {
                args.remove(3);
                args.add(3, "info");
            }
            boolean bl2 = lazySet = !(args.size() < 6 || !rewriteLastArgument && args.size() < 7 || !args.get(2).equalsIgnoreCase("permission") || !args.get(3).toLowerCase().startsWith("set") || !args.get(5).equalsIgnoreCase("none") && !args.get(5).equalsIgnoreCase("0"));
            if (lazySet) {
                args.remove(5);
                args.remove(3);
                args.add(3, "unset");
            }
        }
    }

    public static List<String> stripQuotes(List<String> input) {
        input = new ArrayList<String>(input);
        ListIterator<String> iterator = input.listIterator();
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (value.length() < 3 || value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\"') continue;
            iterator.set(value.substring(1, value.length() - 1));
        }
        return input;
    }
}

