/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.abstraction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandManager;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.locale.command.LocalizedCommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class MainCommand<T, I>
extends Command<Void, T> {
    private final int minArgs;

    public MainCommand(LocalizedCommandSpec spec, String name, int minArgs, List<Command<T, ?>> children) {
        super(spec, name, null, Predicates.alwaysFalse(), children);
        this.minArgs = minArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Void v, List<String> args, String label) {
        block11: {
            if (args.size() < this.minArgs) {
                this.sendUsage(sender, label);
                return CommandResult.INVALID_ARGS;
            }
            Optional<Command> o = this.getChildren().get().stream().filter(s -> s.getName().equalsIgnoreCase((String)args.get(this.minArgs - 1))).limit(1L).findAny();
            if (!o.isPresent()) {
                Message.COMMAND_NOT_RECOGNISED.send(sender, new Object[0]);
                return CommandResult.INVALID_ARGS;
            }
            Command sub = o.get();
            if (!sub.isAuthorized(sender)) {
                Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
                return CommandResult.NO_PERMISSION;
            }
            ArrayList<String> strippedArgs = new ArrayList<String>();
            if (args.size() > this.minArgs) {
                strippedArgs.addAll(args.subList(this.minArgs, args.size()));
            }
            if (sub.getArgumentCheck().test(strippedArgs.size())) {
                sub.sendDetailedUsage(sender, label);
                return CommandResult.INVALID_ARGS;
            }
            String name = args.get(0);
            I targetId = this.parseTarget(name, plugin, sender);
            if (targetId == null) {
                return CommandResult.LOADING_ERROR;
            }
            ReentrantLock lock = this.getLockForTarget(targetId);
            lock.lock();
            try {
                CommandResult result;
                T target = this.getTarget(targetId, plugin, sender);
                if (target == null) break block11;
                try {
                    result = sub.execute(plugin, sender, target, strippedArgs, label);
                }
                catch (CommandException e) {
                    result = CommandManager.handleException(e, sender, label, sub);
                }
                this.cleanup(target, plugin);
                CommandResult commandResult = result;
                return commandResult;
            }
            finally {
                lock.unlock();
            }
        }
        return CommandResult.LOADING_ERROR;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        List<String> objects = this.getTargets(plugin);
        if (args.size() <= 1) {
            if (args.isEmpty() || args.get(0).trim().isEmpty()) {
                return objects;
            }
            return objects.stream().filter(s -> s.toLowerCase().startsWith(((String)args.get(0)).toLowerCase())).collect(Collectors.toList());
        }
        List subs = this.getChildren().get().stream().filter(s -> s.isAuthorized(sender)).collect(Collectors.toList());
        if (args.size() == 2) {
            if (args.get(1).trim().isEmpty()) {
                return subs.stream().map(m -> m.getName().toLowerCase()).collect(Collectors.toList());
            }
            return subs.stream().map(m -> m.getName().toLowerCase()).filter(s -> s.toLowerCase().startsWith(((String)args.get(1)).toLowerCase())).collect(Collectors.toList());
        }
        Optional<Command> o = subs.stream().filter(s -> s.getName().equalsIgnoreCase((String)args.get(1))).findFirst();
        return o.map(cmd -> cmd.tabComplete(plugin, sender, args.subList(2, args.size()))).orElseGet(Collections::emptyList);
    }

    protected abstract List<String> getTargets(LuckPermsPlugin var1);

    protected abstract I parseTarget(String var1, LuckPermsPlugin var2, Sender var3);

    protected abstract ReentrantLock getLockForTarget(I var1);

    protected abstract T getTarget(I var1, LuckPermsPlugin var2, Sender var3);

    protected abstract void cleanup(T var1, LuckPermsPlugin var2);

    @Override
    public void sendUsage(Sender sender, String label) {
        List subs = this.getChildren().get().stream().filter(s -> s.isAuthorized(sender)).collect(Collectors.toList());
        if (!subs.isEmpty()) {
            Message.MAIN_COMMAND_USAGE_HEADER.send(sender, this.getName(), String.format(this.getUsage(), label));
            for (Command s2 : subs) {
                s2.sendUsage(sender, label);
            }
        } else {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
        }
    }

    @Override
    public void sendDetailedUsage(Sender sender, String label) {
        this.sendUsage(sender, label);
    }

    @Override
    public boolean isAuthorized(Sender sender) {
        return this.getChildren().get().stream().anyMatch(sc -> sc.isAuthorized(sender));
    }

    @Override
    public @NonNull Optional<List<Command<T, ?>>> getChildren() {
        return super.getChildren();
    }
}

