/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.lucko.luckperms.api.TemporaryMergeBehaviour;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.commands.user.UserMainCommand;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.utils.DateParser;

public class ArgumentParser {
    public static String parseString(int index, List<String> args) {
        return args.get(index).replace("{SPACE}", " ");
    }

    public static String parseStringOrElse(int index, List<String> args, String other) {
        if (index < 0 || index >= args.size()) {
            return other;
        }
        return args.get(index).replace("{SPACE}", " ");
    }

    public static int parseIntOrElse(int index, List<String> args, int other) {
        if (index < 0 || index >= args.size()) {
            return other;
        }
        try {
            return Integer.parseInt(args.get(index));
        }
        catch (NumberFormatException e) {
            return other;
        }
    }

    public static String parseName(int index, List<String> args) throws ArgumentException {
        String groupName = args.get(index).toLowerCase();
        if (!DataConstraints.GROUP_NAME_TEST.test(groupName)) {
            throw new DetailedUsageException();
        }
        return groupName;
    }

    public static String parseNameWithSpace(int index, List<String> args) throws ArgumentException {
        String groupName = args.get(index).toLowerCase();
        if (!DataConstraints.GROUP_NAME_TEST_ALLOW_SPACE.test(groupName)) {
            throw new DetailedUsageException();
        }
        return groupName;
    }

    public static boolean parseBoolean(int index, List<String> args) {
        String bool;
        if (index < args.size() && ((bool = args.get(index)).equalsIgnoreCase("true") || bool.equalsIgnoreCase("false"))) {
            return Boolean.parseBoolean(bool);
        }
        args.add(index, "true");
        return true;
    }

    public static long parseDuration(int index, List<String> args) throws ArgumentException {
        long duration;
        try {
            duration = Long.parseLong(args.get(index));
        }
        catch (NumberFormatException e) {
            try {
                duration = DateParser.parseDate(args.get(index), true);
            }
            catch (IllegalArgumentException e1) {
                throw new InvalidDateException(args.get(index));
            }
        }
        if (ArgumentParser.shouldExpire(duration)) {
            throw new PastDateException();
        }
        return duration;
    }

    private static boolean shouldExpire(long unixTime) {
        return unixTime < System.currentTimeMillis() / 1000L;
    }

    public static TemporaryMergeBehaviour parseTemporaryModifier(String s) {
        switch (s.toLowerCase()) {
            case "accumulate": {
                return TemporaryMergeBehaviour.ADD_NEW_DURATION_TO_EXISTING;
            }
            case "replace": {
                return TemporaryMergeBehaviour.REPLACE_EXISTING_IF_DURATION_LONGER;
            }
            case "deny": {
                return TemporaryMergeBehaviour.FAIL_WITH_ALREADY_HAS;
            }
        }
        throw new IllegalArgumentException("Unknown value: " + s);
    }

    public static Optional<TemporaryMergeBehaviour> parseTemporaryModifier(int index, List<String> args) {
        if (index < 0 || index >= args.size()) {
            return Optional.empty();
        }
        String s = args.get(index);
        try {
            Optional<TemporaryMergeBehaviour> ret = Optional.of(ArgumentParser.parseTemporaryModifier(s));
            args.remove(index);
            return ret;
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static MutableContextSet parseContext(int fromIndex, List<String> args, LuckPermsPlugin plugin) throws CommandException {
        if (args.size() > fromIndex) {
            MutableContextSet set = MutableContextSet.create();
            List<String> contexts = args.subList(fromIndex, args.size());
            for (int i = 0; i < contexts.size(); ++i) {
                String value;
                String key;
                String pair = contexts.get(i);
                if (i <= 1 && !pair.contains("=")) {
                    String key2 = i == 0 ? "server" : "world";
                    set.add(key2, pair);
                    continue;
                }
                int index = pair.indexOf(61);
                if (index == -1 || (key = pair.substring(0, index)).equals("") || key.trim().isEmpty() || (value = pair.substring(index + 1)).equals("") || value.trim().isEmpty()) continue;
                set.add(key, value);
            }
            return ArgumentParser.sanitizeContexts(set);
        }
        return ArgumentParser.sanitizeContexts(plugin.getConfiguration().getContextsFile().getDefaultContexts().mutableCopy());
    }

    private static MutableContextSet sanitizeContexts(MutableContextSet set) throws ArgumentException {
        ArrayList worlds;
        set.remove("server", "global");
        set.remove("world", "global");
        set.remove("server", "null");
        set.remove("world", "null");
        set.remove("server", "*");
        set.remove("world", "*");
        ArrayList servers = new ArrayList(set.getValues("server"));
        if (servers.size() > 1) {
            for (int i = 1; i < servers.size(); ++i) {
                set.remove("server", (String)servers.get(i));
            }
        }
        if ((worlds = new ArrayList(set.getValues("world"))).size() > 1) {
            for (int i = 1; i < worlds.size(); ++i) {
                set.remove("world", (String)worlds.get(i));
            }
        }
        for (String server : servers) {
            if (DataConstraints.SERVER_NAME_TEST.test(server)) continue;
            throw new InvalidServerWorldException();
        }
        for (String world : worlds) {
            if (DataConstraints.WORLD_NAME_TEST.test(world)) continue;
            throw new InvalidServerWorldException();
        }
        return set;
    }

    public static int parsePriority(int index, List<String> args) throws ArgumentException {
        try {
            return Integer.parseInt(args.get(index));
        }
        catch (NumberFormatException e) {
            throw new InvalidPriorityException(args.get(index));
        }
    }

    public static ImmutableContextSet parseContextSponge(int fromIndex, List<String> args) {
        if (args.size() <= fromIndex) {
            return ImmutableContextSet.empty();
        }
        MutableContextSet contextSet = MutableContextSet.create();
        List<String> toQuery = args.subList(fromIndex, args.size());
        for (String s : toQuery) {
            String value;
            String key;
            int index = s.indexOf(61);
            if (index == -1 || (key = s.substring(0, index)).equals("") || (value = s.substring(index + 1)).equals("")) continue;
            contextSet.add(key, value);
        }
        return contextSet.makeImmutable();
    }

    public static UUID parseUserTarget(int index, List<String> args, LuckPermsPlugin plugin, Sender sender) {
        String target = args.get(index);
        return UserMainCommand.parseTargetUuid(target, plugin, sender);
    }

    public static class InvalidPriorityException
    extends ArgumentException {
        private final String invalidPriority;

        public InvalidPriorityException(String invalidPriority) {
            this.invalidPriority = invalidPriority;
        }

        public String getInvalidPriority() {
            return this.invalidPriority;
        }
    }

    public static class InvalidDateException
    extends ArgumentException {
        private final String invalidDate;

        public InvalidDateException(String invalidDate) {
            this.invalidDate = invalidDate;
        }

        public String getInvalidDate() {
            return this.invalidDate;
        }
    }

    public static class PastDateException
    extends ArgumentException {
    }

    public static class InvalidServerWorldException
    extends ArgumentException {
    }

    public static class DetailedUsageException
    extends ArgumentException {
    }

    public static abstract class ArgumentException
    extends CommandException {
    }
}

