/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.sender.Sender;

public final class MessageUtils {
    public static void sendPluginMessage(Sender sender, String message) {
        String prefix = Message.PREFIX.asString(sender.getPlugin().getLocaleManager(), new Object[0]);
        sender.sendMessage(Message.colorize(prefix + message));
    }

    public static String toCommaSep(Collection<String> strings) {
        if (strings.isEmpty()) {
            return "&bNone";
        }
        StringBuilder sb = new StringBuilder();
        strings.forEach(s -> sb.append("&3").append((String)s).append("&7, "));
        return sb.delete(sb.length() - 2, sb.length()).toString();
    }

    public static String listToArrowSep(Collection<String> strings, String highlight) {
        if (strings.isEmpty()) {
            return "&bNone";
        }
        StringBuilder sb = new StringBuilder();
        strings.forEach(s -> sb.append(s.equalsIgnoreCase(highlight) ? "&b" : "&3").append((String)s).append("&7 ---> "));
        return sb.delete(sb.length() - 6, sb.length()).toString();
    }

    public static String listToArrowSep(Collection<String> strings, String highlightFirst, String highlightSecond, boolean reversed) {
        if (strings.isEmpty()) {
            return "&6None";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            if (s.equalsIgnoreCase(highlightFirst)) {
                sb.append("&b").append(s).append("&4");
            } else if (s.equalsIgnoreCase(highlightSecond)) {
                sb.append("&b").append(s).append("&7");
            } else {
                sb.append("&3").append(s).append("&7");
            }
            sb.append(reversed ? " <--- " : " ---> ");
        }
        return sb.delete(sb.length() - 6, sb.length()).toString();
    }

    public static String listToArrowSep(List<String> strings) {
        if (strings.isEmpty()) {
            return "&6None";
        }
        StringBuilder sb = new StringBuilder();
        strings.forEach(s -> sb.append("&3").append((String)s).append("&b ---> "));
        return sb.delete(sb.length() - 6, sb.length()).toString();
    }

    public static String formatBoolean(boolean b) {
        return b ? "&atrue" : "&cfalse";
    }

    public static String formatTristate(Tristate t) {
        switch (t) {
            case TRUE: {
                return "&atrue";
            }
            case FALSE: {
                return "&cfalse";
            }
        }
        return "&cundefined";
    }

    public static String getAppendableNodeContextString(LocaleManager localeManager, Node node) {
        StringBuilder sb = new StringBuilder();
        if (node.isServerSpecific()) {
            sb.append(" ").append(MessageUtils.contextToString(localeManager, "server", node.getServer().get()));
        }
        if (node.isWorldSpecific()) {
            sb.append(" ").append(MessageUtils.contextToString(localeManager, "world", node.getWorld().get()));
        }
        for (Map.Entry<String, String> c : node.getContexts().toSet()) {
            sb.append(" ").append(MessageUtils.contextToString(localeManager, c.getKey(), c.getValue()));
        }
        return sb.toString();
    }

    public static String contextToString(LocaleManager localeManager, String key, String value) {
        return Message.CONTEXT_PAIR.asString(localeManager, key, value);
    }

    public static String contextSetToString(LocaleManager localeManager, ContextSet set) {
        if (set.isEmpty()) {
            return Message.CONTEXT_PAIR__GLOBAL_INLINE.asString(localeManager, new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : set.toSet()) {
            sb.append(Message.CONTEXT_PAIR_INLINE.asString(localeManager, e.getKey(), e.getValue()));
            sb.append(Message.CONTEXT_PAIR_SEP.asString(localeManager, new Object[0]));
        }
        return sb.delete(sb.length() - Message.CONTEXT_PAIR_SEP.asString(localeManager, new Object[0]).length(), sb.length()).toString();
    }

    private MessageUtils() {
    }
}

