/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.parent;

import java.util.List;
import me.lucko.luckperms.api.DataMutateResult;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.SharedSubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;

public class ParentRemoveTemp
extends SharedSubCommand {
    public ParentRemoveTemp(LocaleManager locale) {
        super(CommandSpec.PARENT_REMOVE_TEMP.localize(locale), "removetemp", CommandPermission.USER_PARENT_REMOVE_TEMP, CommandPermission.GROUP_PARENT_REMOVE_TEMP, Predicates.is(0));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder holder, List<String> args, String label, CommandPermission permission) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, permission, holder)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        String groupName = ArgumentParser.parseNameWithSpace(0, args);
        MutableContextSet context = ArgumentParser.parseContext(1, args, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, permission, context) || ArgumentPermissions.checkGroup(plugin, sender, holder, (ContextSet)context) || ArgumentPermissions.checkGroup(plugin, sender, groupName, (ContextSet)context) || ArgumentPermissions.checkArguments(plugin, sender, permission, groupName)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        DataMutateResult result = holder.unsetPermission(NodeFactory.buildGroupNode(groupName).setExpiry(10L).withExtraContext(context).build());
        if (result.asBoolean()) {
            Message.UNSET_TEMP_INHERIT_SUCCESS.send(sender, holder.getFormattedDisplayName(), groupName, MessageUtils.contextSetToString(plugin.getLocaleManager(), context));
            ExtendedLogEntry.build().actor(sender).acted(holder).action("parent", "removetemp", groupName, context).build().submit(plugin, sender);
            StorageAssistant.save(holder, sender, plugin);
            return CommandResult.SUCCESS;
        }
        Message.DOES_NOT_TEMP_INHERIT.send(sender, holder.getFormattedDisplayName(), groupName, MessageUtils.contextSetToString(plugin.getLocaleManager(), context));
        return CommandResult.STATE_ERROR;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, List<String> args) {
        return TabCompleter.create().at(0, TabCompletions.groups(plugin)).complete(args);
    }
}

