/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.user;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;

public class UserClone
extends SubCommand<User> {
    public UserClone(LocaleManager locale) {
        super(CommandSpec.USER_CLONE.localize(locale), "clone", CommandPermission.USER_CLONE, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, User user, List<String> args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), user)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        UUID uuid = ArgumentParser.parseUserTarget(0, args, plugin, sender);
        if (uuid == null) {
            return CommandResult.INVALID_ARGS;
        }
        User otherUser = plugin.getStorage().loadUser(uuid, null).join();
        if (otherUser == null) {
            Message.USER_LOAD_ERROR.send(sender, new Object[0]);
            return CommandResult.LOADING_ERROR;
        }
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), otherUser)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        otherUser.replaceNodes(NodeMapType.ENDURING, (Multimap<ImmutableContextSet, ? extends Node>)user.enduringData().immutable());
        Message.CLONE_SUCCESS.send(sender, user.getFormattedDisplayName(), otherUser.getFormattedDisplayName());
        ExtendedLogEntry.build().actor(sender).acted(otherUser).action("clone", user.getName()).build().submit(plugin, sender);
        StorageAssistant.save(otherUser, sender, plugin);
        plugin.getUserManager().cleanup(otherUser);
        return CommandResult.SUCCESS;
    }
}

