/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.user;

import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.caching.type.MetaCache;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.DurationFormatter;
import me.lucko.luckperms.common.utils.Predicates;

public class UserInfo
extends SubCommand<User> {
    public UserInfo(LocaleManager locale) {
        super(CommandSpec.USER_INFO.localize(locale), "info", CommandPermission.USER_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, User user, List<String> args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), user)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        Message status = plugin.getBootstrap().isPlayerOnline(user.getUuid()) ? Message.PLAYER_ONLINE : Message.PLAYER_OFFLINE;
        Message.USER_INFO_GENERAL.send(sender, user.getName().orElse("Unknown"), user.getUuid(), user.getUuid().version() == 4 ? "&2mojang" : "&8offline", status.asString(plugin.getLocaleManager(), new Object[0]), user.getPrimaryGroup().getValue());
        Set parents = user.enduringData().asSet().stream().filter(Node::isGroupNode).filter(Node::isPermanent).collect(Collectors.toSet());
        Set tempParents = user.enduringData().asSet().stream().filter(Node::isGroupNode).filter(Node::isTemporary).collect(Collectors.toSet());
        if (!parents.isEmpty()) {
            Message.INFO_PARENT_HEADER.send(sender, new Object[0]);
            for (Node node : parents) {
                Message.INFO_PARENT_ENTRY.send(sender, node.getGroupName(), MessageUtils.getAppendableNodeContextString(plugin.getLocaleManager(), node));
            }
        }
        if (!tempParents.isEmpty()) {
            Message.INFO_TEMP_PARENT_HEADER.send(sender, new Object[0]);
            for (Node node : tempParents) {
                Message.INFO_PARENT_ENTRY.send(sender, node.getGroupName(), MessageUtils.getAppendableNodeContextString(plugin.getLocaleManager(), node));
                Message.INFO_PARENT_ENTRY_EXPIRY.send(sender, DurationFormatter.LONG.formatDateDiff(node.getExpiryUnixTime()));
            }
        }
        String context = "&bNone";
        String prefix = "&bNone";
        String suffix = "&bNone";
        String meta = "&bNone";
        Contexts contexts = plugin.getContextForUser(user).orElse(null);
        if (contexts != null) {
            ListMultimap<String, String> metaMap;
            MetaCache data;
            ContextSet contextSet = contexts.getContexts();
            if (!contextSet.isEmpty()) {
                context = contextSet.toSet().stream().map(e -> MessageUtils.contextToString(plugin.getLocaleManager(), (String)e.getKey(), (String)e.getValue())).collect(Collectors.joining(" "));
            }
            if ((data = user.getCachedData().getMetaData(contexts)).getPrefix() != null) {
                prefix = "&f\"" + data.getPrefix() + "&f\"";
            }
            if (data.getSuffix() != null) {
                suffix = "&f\"" + data.getSuffix() + "&f\"";
            }
            if (!(metaMap = data.getMetaMultimap()).isEmpty()) {
                meta = metaMap.entries().stream().map(e -> MessageUtils.contextToString(plugin.getLocaleManager(), (String)e.getKey(), (String)e.getValue())).collect(Collectors.joining(" "));
            }
        }
        Message.USER_INFO_DATA.send(sender, MessageUtils.formatBoolean(contexts != null), context, prefix, suffix, meta);
        return CommandResult.SUCCESS;
    }
}

