/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.contexts;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import me.lucko.luckperms.api.context.ImmutableContextSet;

public class ContextSetComparator
implements Comparator<ImmutableContextSet> {
    private static final Comparator<ImmutableContextSet> INSTANCE = new ContextSetComparator();
    private static final Comparator<ImmutableContextSet> REVERSE = INSTANCE.reversed();
    private static final Comparator<String> FAST_STRING_COMPARATOR = (o1, o2) -> o1 == o2 ? 0 : o1.compareTo((String)o2);
    private static final Comparator<Map.Entry<String, String>> STRING_ENTRY_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        int ret = FAST_STRING_COMPARATOR.compare((String)o1.getKey(), (String)o2.getKey());
        if (ret != 0) {
            return ret;
        }
        return FAST_STRING_COMPARATOR.compare((String)o1.getValue(), (String)o2.getValue());
    };

    public static Comparator<ImmutableContextSet> normal() {
        return INSTANCE;
    }

    public static Comparator<ImmutableContextSet> reverse() {
        return REVERSE;
    }

    @Override
    public int compare(ImmutableContextSet o1, ImmutableContextSet o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        int result = Boolean.compare(o1.containsKey("server"), o2.containsKey("server"));
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(o1.containsKey("world"), o2.containsKey("world"));
        if (result != 0) {
            return result;
        }
        result = Integer.compare(o1.size(), o2.size());
        if (result != 0) {
            return result;
        }
        ArrayList<Map.Entry<String, String>> o1Entries = new ArrayList<Map.Entry<String, String>>(o1.toSet());
        ArrayList<Map.Entry<String, String>> o2Entries = new ArrayList<Map.Entry<String, String>>(o2.toSet());
        o1Entries.sort(STRING_ENTRY_COMPARATOR);
        o2Entries.sort(STRING_ENTRY_COMPARATOR);
        Iterator it1 = o1Entries.iterator();
        Iterator it2 = o2Entries.iterator();
        while (it1.hasNext()) {
            Map.Entry ent2;
            Map.Entry ent1 = (Map.Entry)it1.next();
            int ret = STRING_ENTRY_COMPARATOR.compare(ent1, ent2 = (Map.Entry)it2.next());
            if (ret == 0) continue;
            return ret;
        }
        throw new AssertionError((Object)("sets are equal? " + o1 + " - " + o2));
    }
}

