/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.contexts;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;

public final class ContextSetJsonSerializer {
    public static JsonObject serializeContextSet(ContextSet contextSet) {
        JsonObject data = new JsonObject();
        Map map = contextSet.toMultimap().asMap();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList values = new ArrayList((Collection)entry.getValue());
            int size = values.size();
            if (size == 1) {
                data.addProperty((String)entry.getKey(), (String)values.get(0));
                continue;
            }
            if (size <= 1) continue;
            JsonArray arr = new JsonArray();
            for (String s : values) {
                arr.add((JsonElement)new JsonPrimitive(s));
            }
            data.add((String)entry.getKey(), (JsonElement)arr);
        }
        return data;
    }

    public static ContextSet deserializeContextSet(Gson gson, String json) {
        Objects.requireNonNull(json, "json");
        if (json.equals("{}")) {
            return ContextSet.empty();
        }
        JsonObject context = (JsonObject)gson.fromJson(json, JsonObject.class);
        if (context == null) {
            return ContextSet.empty();
        }
        return ContextSetJsonSerializer.deserializeContextSet((JsonElement)context);
    }

    public static ContextSet deserializeContextSet(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject data = element.getAsJsonObject();
        if (data.entrySet().isEmpty()) {
            return ContextSet.empty();
        }
        MutableContextSet map = MutableContextSet.create();
        for (Map.Entry e : data.entrySet()) {
            String k = (String)e.getKey();
            JsonElement v = (JsonElement)e.getValue();
            if (v.isJsonArray()) {
                JsonArray values = v.getAsJsonArray();
                for (JsonElement value : values) {
                    map.add(k, value.getAsString());
                }
                continue;
            }
            map.add(k, v.getAsString());
        }
        return map;
    }

    private ContextSetJsonSerializer() {
    }
}

