/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.managers.group;

import java.util.Optional;
import me.lucko.luckperms.common.managers.AbstractManager;
import me.lucko.luckperms.common.managers.group.GroupManager;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;

public abstract class AbstractGroupManager<T extends Group>
extends AbstractManager<String, Group, T>
implements GroupManager<T> {
    @Override
    public T getByDisplayName(String name) {
        Optional<String> displayName;
        Group g = (Group)this.getIfLoaded(name);
        if (g != null) {
            return (T)g;
        }
        for (Group group : this.getAll().values()) {
            displayName = group.getDisplayName();
            if (!displayName.isPresent() || !displayName.get().equals(name)) continue;
            return (T)group;
        }
        for (Group group : this.getAll().values()) {
            displayName = group.getDisplayName();
            if (!displayName.isPresent() || !displayName.get().equalsIgnoreCase(name)) continue;
            return (T)group;
        }
        return null;
    }

    @Override
    protected String sanitizeIdentifier(String s) {
        return s.toLowerCase();
    }

    @Override
    public void invalidateAllGroupCaches() {
        this.getAll().values().forEach(PermissionHolder::invalidateCachedData);
    }
}

