/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.metastacking;

import java.util.ArrayList;
import java.util.List;
import me.lucko.luckperms.api.ChatMetaType;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.metastacking.MetaStackDefinition;
import me.lucko.luckperms.api.metastacking.MetaStackElement;
import me.lucko.luckperms.common.metastacking.MetaStack;
import me.lucko.luckperms.common.metastacking.MetaStackEntry;
import me.lucko.luckperms.common.metastacking.SimpleMetaStackEntry;
import me.lucko.luckperms.common.utils.ImmutableCollectors;

public final class SimpleMetaStack
implements MetaStack {
    private final MetaStackDefinition definition;
    private final ChatMetaType targetType;
    private final List<MetaStackEntry> entries;

    public SimpleMetaStack(MetaStackDefinition definition, ChatMetaType targetType) {
        this.definition = definition;
        this.targetType = targetType;
        this.entries = (List)definition.getElements().stream().map(element -> new SimpleMetaStackEntry(this, (MetaStackElement)element, targetType)).collect(ImmutableCollectors.toList());
    }

    @Override
    public String toFormattedString() {
        ArrayList<MetaStackEntry> ret = new ArrayList<MetaStackEntry>(this.entries);
        ret.removeIf(m -> !m.getCurrentValue().isPresent());
        if (ret.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.definition.getStartSpacer());
        for (int i = 0; i < ret.size(); ++i) {
            if (i != 0) {
                sb.append(this.definition.getMiddleSpacer());
            }
            MetaStackEntry e = (MetaStackEntry)ret.get(i);
            sb.append(e.getCurrentValue().get().getValue());
        }
        sb.append(this.definition.getEndSpacer());
        return sb.toString();
    }

    @Override
    public void accumulateToAll(LocalizedNode node) {
        this.entries.forEach(e -> e.accumulateNode(node));
    }

    @Override
    public MetaStackDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public ChatMetaType getTargetType() {
        return this.targetType;
    }
}

