/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.comparator;

import java.util.Comparator;
import me.lucko.luckperms.api.Node;

public class NodeComparator
implements Comparator<Node> {
    private static final Comparator<? super Node> INSTANCE = new NodeComparator();
    private static final Comparator<? super Node> REVERSE = INSTANCE.reversed();

    public static Comparator<? super Node> normal() {
        return INSTANCE;
    }

    public static Comparator<? super Node> reverse() {
        return REVERSE;
    }

    @Override
    public int compare(Node o1, Node o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        int result = Boolean.compare(o1.isOverride(), o2.isOverride());
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(o1.isTemporary(), o2.isTemporary());
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(o1.isWildcard(), o2.isWildcard());
        if (result != 0) {
            return result;
        }
        if (o1.isTemporary() && (result = -Long.compare(o1.getSecondsTilExpiry(), o2.getSecondsTilExpiry())) != 0) {
            return result;
        }
        if (o1.isWildcard() && (result = Integer.compare(o1.getWildcardLevel(), o2.getWildcardLevel())) != 0) {
            return result;
        }
        result = -o1.getPermission().compareTo(o2.getPermission());
        if (result != 0) {
            return result;
        }
        result = -Boolean.compare(o1.getValue(), o2.getValue());
        if (result != 0) {
            return result;
        }
        throw new AssertionError((Object)("nodes are equal? " + o1 + " - " + o2));
    }
}

