/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.StandardNodeEquality;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;
import me.lucko.luckperms.api.nodetype.NodeType;
import me.lucko.luckperms.api.nodetype.NodeTypeKey;
import me.lucko.luckperms.api.nodetype.types.RegexType;
import me.lucko.luckperms.common.node.factory.NodeBuilder;
import me.lucko.luckperms.common.node.model.ForwardingNode;
import me.lucko.luckperms.common.node.model.NodeTypes;
import me.lucko.luckperms.common.node.utils.ShorthandParser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ImmutableNode
implements Node {
    public static final char NODE_SEPARATOR = '.';
    public static final int NODE_SEPARATOR_CODE = Character.getNumericValue('.');
    private final String permission;
    private final boolean value;
    private boolean override;
    private final @Nullable String server;
    private final @Nullable String world;
    private final long expireAt;
    private final ImmutableContextSet contexts;
    private final ImmutableContextSet fullContexts;
    private final Optional<String> optServer;
    private final Optional<String> optWorld;
    private final int hashCode;
    private final int wildcardLevel;
    private final Map<NodeTypeKey<?>, NodeType> resolvedTypes;
    private final List<String> resolvedShorthand;

    public ImmutableNode(String permission, boolean value, boolean override, long expireAt, String server, String world, ContextSet contexts) {
        if (permission == null || permission.isEmpty()) {
            throw new IllegalArgumentException("Empty permission");
        }
        server = ImmutableNode.standardizeServerWorld(server);
        world = ImmutableNode.standardizeServerWorld(world);
        this.permission = permission.intern();
        this.value = value;
        this.override = override;
        this.expireAt = expireAt;
        this.server = ImmutableNode.internString(server);
        this.world = ImmutableNode.internString(world);
        this.contexts = contexts == null ? ContextSet.empty() : contexts.makeImmutable();
        this.wildcardLevel = this.permission.endsWith(".*") ? this.permission.chars().filter(num -> num == NODE_SEPARATOR_CODE).sum() : -1;
        this.resolvedTypes = NodeTypes.parseTypes(this.permission);
        this.resolvedShorthand = this.resolvedTypes.containsKey(RegexType.KEY) ? ImmutableList.of() : ImmutableList.copyOf(ShorthandParser.parseShorthand(this.getPermission()));
        this.optServer = Optional.ofNullable(this.server);
        this.optWorld = Optional.ofNullable(this.world);
        if (this.server != null || this.world != null) {
            MutableContextSet fullContexts = this.contexts.mutableCopy();
            if (this.server != null) {
                fullContexts.add("server", this.server);
            }
            if (this.world != null) {
                fullContexts.add("world", this.world);
            }
            this.fullContexts = fullContexts.makeImmutable();
        } else {
            this.fullContexts = this.contexts;
        }
        this.hashCode = this.calculateHashCode();
    }

    @Override
    public Node.Builder toBuilder() {
        return new NodeBuilder(this);
    }

    @Override
    public @NonNull String getPermission() {
        return this.permission;
    }

    @Override
    public boolean getValue() {
        return this.value;
    }

    @Override
    public boolean isOverride() {
        return this.override;
    }

    @Override
    public @NonNull Optional<String> getServer() {
        return this.optServer;
    }

    @Override
    public @NonNull Optional<String> getWorld() {
        return this.optWorld;
    }

    @Override
    public boolean isServerSpecific() {
        return this.server != null;
    }

    @Override
    public boolean isWorldSpecific() {
        return this.world != null;
    }

    @Override
    public @NonNull ImmutableContextSet getContexts() {
        return this.contexts;
    }

    @Override
    public @NonNull ImmutableContextSet getFullContexts() {
        return this.fullContexts;
    }

    @Override
    public boolean appliesGlobally() {
        return this.server == null && this.world == null && this.contexts.isEmpty();
    }

    @Override
    public boolean hasSpecificContext() {
        return this.server != null || this.world != null || !this.contexts.isEmpty();
    }

    @Override
    public boolean shouldApplyWithContext(@NonNull ContextSet contextSet) {
        return this.getFullContexts().isSatisfiedBy(contextSet);
    }

    @Override
    public boolean isTemporary() {
        return this.expireAt != 0L;
    }

    @Override
    public long getExpiryUnixTime() {
        Preconditions.checkState((boolean)this.isTemporary(), (Object)"Node does not have an expiry time.");
        return this.expireAt;
    }

    @Override
    public @NonNull Date getExpiry() {
        Preconditions.checkState((boolean)this.isTemporary(), (Object)"Node does not have an expiry time.");
        return new Date(this.expireAt * 1000L);
    }

    @Override
    public long getSecondsTilExpiry() {
        Preconditions.checkState((boolean)this.isTemporary(), (Object)"Node does not have an expiry time.");
        return this.expireAt - System.currentTimeMillis() / 1000L;
    }

    @Override
    public boolean hasExpired() {
        return this.isTemporary() && this.expireAt < System.currentTimeMillis() / 1000L;
    }

    @Override
    public boolean isWildcard() {
        return this.wildcardLevel != -1;
    }

    @Override
    public int getWildcardLevel() {
        Preconditions.checkState((boolean)this.isWildcard(), (Object)"Node is not a wildcard");
        return this.wildcardLevel;
    }

    @Override
    public boolean hasTypeData() {
        return !this.resolvedTypes.isEmpty();
    }

    @Override
    public <T extends NodeType> Optional<T> getTypeData(NodeTypeKey<T> key) {
        Objects.requireNonNull(key, "key");
        NodeType result = this.resolvedTypes.get(key);
        return Optional.ofNullable(result);
    }

    @Override
    public @NonNull List<String> resolveShorthand() {
        return this.resolvedShorthand;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        while (other instanceof ForwardingNode) {
            other = ((ForwardingNode)other).delegate();
        }
        return other instanceof ImmutableNode && Equality.EXACT.areEqual(this, (ImmutableNode)other);
    }

    @Override
    public boolean standardEquals(Node o, StandardNodeEquality equalityPredicate) {
        while (o instanceof ForwardingNode) {
            o = ((ForwardingNode)o).delegate();
        }
        if (!(o instanceof ImmutableNode)) {
            return false;
        }
        ImmutableNode other = (ImmutableNode)o;
        switch (equalityPredicate) {
            case EXACT: {
                return Equality.EXACT.areEqual(this, other);
            }
            case IGNORE_VALUE: {
                return Equality.IGNORE_VALUE.areEqual(this, other);
            }
            case IGNORE_EXPIRY_TIME: {
                return Equality.IGNORE_EXPIRY_TIME.areEqual(this, other);
            }
            case IGNORE_EXPIRY_TIME_AND_VALUE: {
                return Equality.IGNORE_EXPIRY_TIME_AND_VALUE.areEqual(this, other);
            }
            case IGNORE_VALUE_OR_IF_TEMPORARY: {
                return Equality.IGNORE_VALUE_OR_IF_TEMPORARY.areEqual(this, other);
            }
        }
        throw new AssertionError();
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.permission.hashCode();
        result = result * 59 + (this.value ? 79 : 97);
        result = result * 59 + (this.override ? 79 : 97);
        result = result * 59 + (this.server == null ? 43 : this.server.hashCode());
        result = result * 59 + (this.world == null ? 43 : this.world.hashCode());
        result = result * 59 + (int)(this.expireAt >>> 32 ^ this.expireAt);
        result = result * 59 + this.contexts.hashCode();
        return result;
    }

    private static String internString(String s) {
        return s == null ? null : s.intern();
    }

    private static String standardizeServerWorld(String s) {
        if (s != null && ((s = s.toLowerCase()).equals("global") || s.isEmpty())) {
            s = null;
        }
        return s;
    }

    public String toString() {
        return "ImmutableNode(permission=" + this.permission + ", value=" + this.value + ", override=" + this.override + ", server=" + this.getServer() + ", world=" + this.getWorld() + ", expireAt=" + this.expireAt + ", contexts=" + this.contexts + ")";
    }

    private static enum Equality {
        EXACT{

            @Override
            public boolean areEqual(@NonNull ImmutableNode o1, @NonNull ImmutableNode o2) {
                return o1 == o2 || o1.permission == o2.permission && o1.value == o2.value && o1.override == o2.override && (o1.server == null ? o2.server == null : o1.server.equals(o2.server)) && (o1.world == null ? o2.world == null : o1.world.equals(o2.world)) && o1.expireAt == o2.expireAt && o1.getContexts().equals(o2.getContexts());
            }
        }
        ,
        IGNORE_VALUE{

            @Override
            public boolean areEqual(@NonNull ImmutableNode o1, @NonNull ImmutableNode o2) {
                return o1 == o2 || o1.permission == o2.permission && o1.override == o2.override && (o1.server == null ? o2.server == null : o1.server.equals(o2.server)) && (o1.world == null ? o2.world == null : o1.world.equals(o2.world)) && o1.expireAt == o2.expireAt && o1.getContexts().equals(o2.getContexts());
            }
        }
        ,
        IGNORE_EXPIRY_TIME{

            @Override
            public boolean areEqual(@NonNull ImmutableNode o1, @NonNull ImmutableNode o2) {
                return o1 == o2 || o1.permission == o2.permission && o1.value == o2.value && o1.override == o2.override && (o1.server == null ? o2.server == null : o1.server.equals(o2.server)) && (o1.world == null ? o2.world == null : o1.world.equals(o2.world)) && o1.isTemporary() == o2.isTemporary() && o1.getContexts().equals(o2.getContexts());
            }
        }
        ,
        IGNORE_EXPIRY_TIME_AND_VALUE{

            @Override
            public boolean areEqual(@NonNull ImmutableNode o1, @NonNull ImmutableNode o2) {
                return o1 == o2 || o1.permission == o2.permission && o1.override == o2.override && (o1.server == null ? o2.server == null : o1.server.equals(o2.server)) && (o1.world == null ? o2.world == null : o1.world.equals(o2.world)) && o1.isTemporary() == o2.isTemporary() && o1.getContexts().equals(o2.getContexts());
            }
        }
        ,
        IGNORE_VALUE_OR_IF_TEMPORARY{

            @Override
            public boolean areEqual(@NonNull ImmutableNode o1, @NonNull ImmutableNode o2) {
                return o1 == o2 || o1.permission == o2.permission && o1.override == o2.override && (o1.server == null ? o2.server == null : o1.server.equals(o2.server)) && (o1.world == null ? o2.world == null : o1.world.equals(o2.world)) && o1.getContexts().equals(o2.getContexts());
            }
        };


        public abstract boolean areEqual(@NonNull ImmutableNode var1, @NonNull ImmutableNode var2);
    }
}

