/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.model;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import me.lucko.luckperms.api.nodetype.NodeType;
import me.lucko.luckperms.api.nodetype.NodeTypeKey;
import me.lucko.luckperms.api.nodetype.types.DisplayNameType;
import me.lucko.luckperms.api.nodetype.types.InheritanceType;
import me.lucko.luckperms.api.nodetype.types.MetaType;
import me.lucko.luckperms.api.nodetype.types.PrefixType;
import me.lucko.luckperms.api.nodetype.types.RegexType;
import me.lucko.luckperms.api.nodetype.types.SuffixType;
import me.lucko.luckperms.api.nodetype.types.WeightType;
import me.lucko.luckperms.common.buffers.Cache;
import me.lucko.luckperms.common.node.factory.LegacyNodeFactory;
import me.lucko.luckperms.common.utils.PatternCache;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NodeTypes {
    public static final String PREFIX_KEY = "prefix";
    public static final String SUFFIX_KEY = "suffix";
    public static final String META_KEY = "meta";
    public static final String WEIGHT_KEY = "weight";
    public static final String DISPLAY_NAME_KEY = "displayname";
    public static final String GROUP_NODE_MARKER = "group.";
    public static final String PREFIX_NODE_MARKER = "prefix.";
    public static final String SUFFIX_NODE_MARKER = "suffix.";
    public static final String META_NODE_MARKER = "meta.";
    public static final String WEIGHT_NODE_MARKER = "weight.";
    public static final String DISPLAY_NAME_NODE_MARKER = "displayname.";
    public static final String REGEX_MARKER_1 = "r=";
    public static final String REGEX_MARKER_2 = "R=";
    private static final Splitter META_SPLITTER = Splitter.on((Pattern)PatternCache.compileDelimiterPattern(".", "\\")).limit(2);

    public static @NonNull Map<NodeTypeKey<?>, NodeType> parseTypes(String s) {
        IdentityHashMap results = new IdentityHashMap();
        NodeType type = NodeTypes.parseInheritanceType(s);
        if (type != null) {
            results.put(InheritanceType.KEY, type);
        }
        if ((type = NodeTypes.parseMetaType(s)) != null) {
            results.put(MetaType.KEY, type);
        }
        if ((type = NodeTypes.parsePrefixType(s)) != null) {
            results.put(PrefixType.KEY, type);
        }
        if ((type = NodeTypes.parseSuffixType(s)) != null) {
            results.put(SuffixType.KEY, type);
        }
        if ((type = NodeTypes.parseWeightType(s)) != null) {
            results.put(WeightType.KEY, type);
        }
        if ((type = NodeTypes.parseDisplayNameType(s)) != null) {
            results.put(DisplayNameType.KEY, type);
        }
        if ((type = NodeTypes.parseRegexType(s)) != null) {
            results.put(RegexType.KEY, type);
        }
        if (results.isEmpty()) {
            return ImmutableMap.of();
        }
        return results;
    }

    public static @Nullable InheritanceType parseInheritanceType(String s) {
        if (!(s = s.toLowerCase()).startsWith(GROUP_NODE_MARKER)) {
            return null;
        }
        String groupName = s.substring(GROUP_NODE_MARKER.length()).intern();
        return new Inheritance(groupName);
    }

    public static @Nullable MetaType parseMetaType(String s) {
        if (!s.toLowerCase().startsWith(META_NODE_MARKER)) {
            return null;
        }
        Iterator metaParts = META_SPLITTER.split((CharSequence)s.substring(META_NODE_MARKER.length())).iterator();
        if (!metaParts.hasNext()) {
            return null;
        }
        String key = (String)metaParts.next();
        if (!metaParts.hasNext()) {
            return null;
        }
        String value = (String)metaParts.next();
        return new Meta(LegacyNodeFactory.unescapeCharacters(key).intern(), LegacyNodeFactory.unescapeCharacters(value).intern());
    }

    public static @Nullable PrefixType parsePrefixType(String s) {
        if (!s.toLowerCase().startsWith(PREFIX_NODE_MARKER)) {
            return null;
        }
        Iterator metaParts = META_SPLITTER.split((CharSequence)s.substring(PREFIX_NODE_MARKER.length())).iterator();
        if (!metaParts.hasNext()) {
            return null;
        }
        String priority = (String)metaParts.next();
        if (!metaParts.hasNext()) {
            return null;
        }
        String value = (String)metaParts.next();
        try {
            int p = Integer.parseInt(priority);
            String v = LegacyNodeFactory.unescapeCharacters(value).intern();
            return new Prefix(p, v);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static @Nullable SuffixType parseSuffixType(String s) {
        if (!s.toLowerCase().startsWith(SUFFIX_NODE_MARKER)) {
            return null;
        }
        Iterator metaParts = META_SPLITTER.split((CharSequence)s.substring(SUFFIX_NODE_MARKER.length())).iterator();
        if (!metaParts.hasNext()) {
            return null;
        }
        String priority = (String)metaParts.next();
        if (!metaParts.hasNext()) {
            return null;
        }
        String value = (String)metaParts.next();
        try {
            int p = Integer.parseInt(priority);
            String v = LegacyNodeFactory.unescapeCharacters(value).intern();
            return new Suffix(p, v);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static @Nullable WeightType parseWeightType(String s) {
        String lower = s.toLowerCase();
        if (!lower.startsWith(WEIGHT_NODE_MARKER)) {
            return null;
        }
        String i = lower.substring(WEIGHT_NODE_MARKER.length());
        try {
            return new Weight(Integer.parseInt(i));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static @Nullable DisplayNameType parseDisplayNameType(String s) {
        if (!s.toLowerCase().startsWith(DISPLAY_NAME_NODE_MARKER)) {
            return null;
        }
        return new DisplayName(s.substring(DISPLAY_NAME_NODE_MARKER.length()));
    }

    public static @Nullable RegexType parseRegexType(String s) {
        if (!s.startsWith(REGEX_MARKER_1) && !s.startsWith(REGEX_MARKER_2)) {
            return null;
        }
        return new Regex(s.substring(2));
    }

    private NodeTypes() {
    }

    private static final class Regex
    extends Cache<PatternCache.CachedPattern>
    implements RegexType {
        private final String patternString;

        private Regex(String patternString) {
            this.patternString = patternString;
        }

        @Override
        protected @NonNull PatternCache.CachedPattern supply() {
            return PatternCache.lookup(this.patternString);
        }

        @Override
        public @NonNull String getPatternString() {
            return this.patternString;
        }

        @Override
        public @NonNull Optional<Pattern> getPattern() {
            return Optional.ofNullable(((PatternCache.CachedPattern)this.get()).getPattern());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Regex that = (Regex)o;
            return Objects.equals(this.patternString, that.patternString);
        }

        public int hashCode() {
            return Objects.hash(this.patternString);
        }

        public String toString() {
            return "Regex{pattern=" + this.patternString + '}';
        }
    }

    private static final class DisplayName
    implements DisplayNameType {
        private final String displayName;

        private DisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public @NonNull String getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisplayName that = (DisplayName)o;
            return Objects.equals(this.displayName, that.displayName);
        }

        public int hashCode() {
            return Objects.hash(this.displayName);
        }

        public String toString() {
            return "DisplayName{displayName='" + this.displayName + '\'' + '}';
        }
    }

    private static final class Weight
    implements WeightType {
        private final int weight;

        private Weight(int weight) {
            this.weight = weight;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Weight that = (Weight)o;
            return this.weight == that.weight;
        }

        public int hashCode() {
            return Objects.hash(this.weight);
        }

        public String toString() {
            return "WeightType{weight=" + this.weight + '}';
        }
    }

    private static final class Suffix
    implements SuffixType,
    Map.Entry<Integer, String> {
        private final int priority;
        private final String suffix;

        private Suffix(int priority, String suffix) {
            this.priority = priority;
            this.suffix = suffix;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public @NonNull String getSuffix() {
            return this.suffix;
        }

        @Override
        public @NonNull Map.Entry<Integer, String> getAsEntry() {
            return this;
        }

        @Override
        public Integer getKey() {
            return this.getPriority();
        }

        @Override
        public String getValue() {
            return this.getSuffix();
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Suffix that = (Suffix)o;
            return this.priority == that.priority && Objects.equals(this.suffix, that.suffix);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.priority, this.suffix);
        }

        public String toString() {
            return "SuffixType{priority=" + this.priority + ", suffix='" + this.suffix + "'}";
        }
    }

    private static final class Prefix
    implements PrefixType,
    Map.Entry<Integer, String> {
        private final int priority;
        private final String prefix;

        private Prefix(int priority, String prefix) {
            this.priority = priority;
            this.prefix = prefix;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public @NonNull String getPrefix() {
            return this.prefix;
        }

        @Override
        public @NonNull Map.Entry<Integer, String> getAsEntry() {
            return this;
        }

        @Override
        public Integer getKey() {
            return this.getPriority();
        }

        @Override
        public String getValue() {
            return this.getPrefix();
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Prefix that = (Prefix)o;
            return this.priority == that.priority && Objects.equals(this.prefix, that.prefix);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.priority, this.prefix);
        }

        public String toString() {
            return "PrefixType{priority=" + this.priority + ", prefix='" + this.prefix + "'}";
        }
    }

    private static final class Meta
    implements MetaType {
        private final String key;
        private final String value;

        private Meta(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public @NonNull String getKey() {
            return this.key;
        }

        @Override
        public @NonNull String getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Meta that = (Meta)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "MetaType{key='" + this.key + "', value='" + this.value + "'}";
        }
    }

    private static final class Inheritance
    implements InheritanceType {
        private final String groupName;

        private Inheritance(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public @NonNull String getGroupName() {
            return this.groupName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Inheritance that = (Inheritance)o;
            return Objects.equals(this.groupName, that.groupName);
        }

        public int hashCode() {
            return Objects.hash(this.groupName);
        }

        public String toString() {
            return "InheritanceType{groupName='" + this.groupName + "'}";
        }
    }
}

