/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.Storage;
import me.lucko.luckperms.common.storage.StorageType;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.implementation.custom.CustomStorageProviders;
import me.lucko.luckperms.common.storage.implementation.file.CombinedConfigurateStorage;
import me.lucko.luckperms.common.storage.implementation.file.SeparatedConfigurateStorage;
import me.lucko.luckperms.common.storage.implementation.file.loader.HoconLoader;
import me.lucko.luckperms.common.storage.implementation.file.loader.JsonLoader;
import me.lucko.luckperms.common.storage.implementation.file.loader.TomlLoader;
import me.lucko.luckperms.common.storage.implementation.file.loader.YamlLoader;
import me.lucko.luckperms.common.storage.implementation.mongodb.MongoStorage;
import me.lucko.luckperms.common.storage.implementation.split.SplitStorage;
import me.lucko.luckperms.common.storage.implementation.split.SplitStorageType;
import me.lucko.luckperms.common.storage.implementation.sql.SqlStorage;
import me.lucko.luckperms.common.storage.implementation.sql.connection.file.H2ConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.file.SQLiteConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.MariaDbConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.MySqlConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.PostgreConnectionFactory;
import me.lucko.luckperms.common.utils.ImmutableCollectors;

public class StorageFactory {
    private final LuckPermsPlugin plugin;

    public StorageFactory(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    public Set<StorageType> getRequiredTypes(StorageType defaultMethod) {
        if (this.plugin.getConfiguration().get(ConfigKeys.SPLIT_STORAGE).booleanValue()) {
            return (Set)this.plugin.getConfiguration().get(ConfigKeys.SPLIT_STORAGE_OPTIONS).entrySet().stream().map(e -> {
                StorageType type = StorageType.parse((String)e.getValue());
                if (type == null) {
                    this.plugin.getLogger().severe("Storage method for " + e.getKey() + " - " + (String)e.getValue() + " not recognised. Using the default instead.");
                    type = defaultMethod;
                }
                return type;
            }).collect(ImmutableCollectors.toEnumSet(StorageType.class));
        }
        String method = this.plugin.getConfiguration().get(ConfigKeys.STORAGE_METHOD);
        StorageType type = StorageType.parse(method);
        if (type == null) {
            this.plugin.getLogger().severe("Storage method '" + method + "' not recognised. Using the default instead.");
            type = defaultMethod;
        }
        return ImmutableSet.of((Object)((Object)type));
    }

    public Storage getInstance(StorageType defaultMethod) {
        Storage storage;
        if (this.plugin.getConfiguration().get(ConfigKeys.SPLIT_STORAGE).booleanValue()) {
            this.plugin.getLogger().info("Loading storage provider... [SPLIT STORAGE]");
            Map mappedTypes = (Map)this.plugin.getConfiguration().get(ConfigKeys.SPLIT_STORAGE_OPTIONS).entrySet().stream().map(e -> {
                StorageType type = StorageType.parse((String)e.getValue());
                if (type == null) {
                    type = defaultMethod;
                }
                return Maps.immutableEntry(e.getKey(), (Object)((Object)type));
            }).collect(ImmutableCollectors.toEnumMap(SplitStorageType.class, Map.Entry::getKey, Map.Entry::getValue));
            Map backing = (Map)mappedTypes.values().stream().distinct().collect(ImmutableCollectors.toEnumMap(StorageType.class, e -> e, this::createNewImplementation));
            storage = new Storage(this.plugin, new SplitStorage(this.plugin, backing, mappedTypes));
        } else {
            String method = this.plugin.getConfiguration().get(ConfigKeys.STORAGE_METHOD);
            StorageType type = StorageType.parse(method);
            if (type == null) {
                type = defaultMethod;
            }
            this.plugin.getLogger().info("Loading storage provider... [" + type.name() + "]");
            storage = this.makeInstance(type);
        }
        storage.init();
        return storage;
    }

    private Storage makeInstance(StorageType type) {
        return new Storage(this.plugin, this.createNewImplementation(type));
    }

    private StorageImplementation createNewImplementation(StorageType method) {
        switch (method) {
            case CUSTOM: {
                return CustomStorageProviders.getProvider().provide(this.plugin);
            }
            case MARIADB: {
                return new SqlStorage(this.plugin, new MariaDbConnectionFactory(this.plugin.getConfiguration().get(ConfigKeys.DATABASE_VALUES)), this.plugin.getConfiguration().get(ConfigKeys.SQL_TABLE_PREFIX));
            }
            case MYSQL: {
                return new SqlStorage(this.plugin, new MySqlConnectionFactory(this.plugin.getConfiguration().get(ConfigKeys.DATABASE_VALUES)), this.plugin.getConfiguration().get(ConfigKeys.SQL_TABLE_PREFIX));
            }
            case SQLITE: {
                return new SqlStorage(this.plugin, new SQLiteConnectionFactory(this.plugin, this.plugin.getBootstrap().getDataDirectory().resolve("luckperms-sqlite.db")), this.plugin.getConfiguration().get(ConfigKeys.SQL_TABLE_PREFIX));
            }
            case H2: {
                return new SqlStorage(this.plugin, new H2ConnectionFactory(this.plugin, this.plugin.getBootstrap().getDataDirectory().resolve("luckperms-h2")), this.plugin.getConfiguration().get(ConfigKeys.SQL_TABLE_PREFIX));
            }
            case POSTGRESQL: {
                return new SqlStorage(this.plugin, new PostgreConnectionFactory(this.plugin.getConfiguration().get(ConfigKeys.DATABASE_VALUES)), this.plugin.getConfiguration().get(ConfigKeys.SQL_TABLE_PREFIX));
            }
            case MONGODB: {
                return new MongoStorage(this.plugin, this.plugin.getConfiguration().get(ConfigKeys.DATABASE_VALUES), this.plugin.getConfiguration().get(ConfigKeys.MONGODB_COLLECTION_PREFIX), this.plugin.getConfiguration().get(ConfigKeys.MONGODB_CONNECTION_URI));
            }
            case YAML: {
                return new SeparatedConfigurateStorage(this.plugin, "YAML", new YamlLoader(), ".yml", "yaml-storage");
            }
            case JSON: {
                return new SeparatedConfigurateStorage(this.plugin, "JSON", new JsonLoader(), ".json", "json-storage");
            }
            case HOCON: {
                return new SeparatedConfigurateStorage(this.plugin, "HOCON", new HoconLoader(), ".conf", "hocon-storage");
            }
            case TOML: {
                return new SeparatedConfigurateStorage(this.plugin, "TOML", new TomlLoader(), ".toml", "toml-storage");
            }
            case YAML_COMBINED: {
                return new CombinedConfigurateStorage(this.plugin, "YAML Combined", new YamlLoader(), ".yml", "yaml-storage");
            }
            case JSON_COMBINED: {
                return new CombinedConfigurateStorage(this.plugin, "JSON Combined", new JsonLoader(), ".json", "json-storage");
            }
            case HOCON_COMBINED: {
                return new CombinedConfigurateStorage(this.plugin, "HOCON Combined", new HoconLoader(), ".conf", "hocon-storage");
            }
            case TOML_COMBINED: {
                return new CombinedConfigurateStorage(this.plugin, "TOML Combined", new TomlLoader(), ".toml", "toml-storage");
            }
        }
        throw new RuntimeException("Unknown method: " + (Object)((Object)method));
    }
}

