/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.misc;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import me.lucko.luckperms.api.PlayerSaveResult;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PlayerSaveResultImpl
implements PlayerSaveResult {
    private static final PlayerSaveResultImpl CLEAN_INSERT = new PlayerSaveResultImpl(PlayerSaveResult.Status.CLEAN_INSERT);
    private static final PlayerSaveResultImpl NO_CHANGE = new PlayerSaveResultImpl(PlayerSaveResult.Status.NO_CHANGE);
    private final Set<PlayerSaveResult.Status> status;
    private final @Nullable String oldUsername;
    private final @Nullable Set<UUID> otherUuids;

    public static PlayerSaveResultImpl cleanInsert() {
        return CLEAN_INSERT;
    }

    public static PlayerSaveResultImpl noChange() {
        return NO_CHANGE;
    }

    public static PlayerSaveResultImpl usernameUpdated(String oldUsername) {
        return new PlayerSaveResultImpl(EnumSet.of(PlayerSaveResult.Status.USERNAME_UPDATED), oldUsername, null);
    }

    public static PlayerSaveResultImpl determineBaseResult(String username, String oldUsername) {
        PlayerSaveResultImpl result = oldUsername == null ? PlayerSaveResultImpl.cleanInsert() : (oldUsername.equalsIgnoreCase(username) ? PlayerSaveResultImpl.noChange() : PlayerSaveResultImpl.usernameUpdated(oldUsername));
        return result;
    }

    private PlayerSaveResultImpl(EnumSet<PlayerSaveResult.Status> status, @Nullable String oldUsername, @Nullable Set<UUID> otherUuids) {
        this.status = ImmutableSet.copyOf(status);
        this.oldUsername = oldUsername;
        this.otherUuids = otherUuids;
    }

    private PlayerSaveResultImpl(PlayerSaveResult.Status status) {
        this(EnumSet.of(status), null, null);
    }

    public PlayerSaveResultImpl withOtherUuidsPresent(@NonNull Set<UUID> otherUuids) {
        EnumSet<PlayerSaveResult.Status> status = EnumSet.copyOf(this.status);
        status.add(PlayerSaveResult.Status.OTHER_UUIDS_PRESENT_FOR_USERNAME);
        return new PlayerSaveResultImpl(status, this.oldUsername, (Set<UUID>)ImmutableSet.copyOf(otherUuids));
    }

    @Override
    public @NonNull Set<PlayerSaveResult.Status> getStatus() {
        return this.status;
    }

    @Override
    public boolean includes(@NonNull PlayerSaveResult.Status status) {
        return this.status.contains((Object)status);
    }

    @Override
    public @Nullable String getOldUsername() {
        return this.oldUsername;
    }

    @Override
    public @Nullable Set<UUID> getOtherUuids() {
        return this.otherUuids;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        PlayerSaveResultImpl result = (PlayerSaveResultImpl)that;
        return Objects.equals(this.status, result.status) && Objects.equals(this.oldUsername, result.oldUsername) && Objects.equals(this.otherUuids, result.otherUuids);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.oldUsername, this.otherUuids);
    }

    public String toString() {
        return "PlayerSaveResult(status=" + this.status + ", oldUsername=" + this.oldUsername + ", otherUuids=" + this.otherUuids + ")";
    }
}

