/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.LuckPermsApi;
import me.lucko.luckperms.common.api.LuckPermsApiProvider;
import me.lucko.luckperms.common.calculators.CalculatorFactory;
import me.lucko.luckperms.common.command.CommandManager;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.config.adapter.ConfigurationAdapter;
import me.lucko.luckperms.common.contexts.ContextManager;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.event.AbstractEventBus;
import me.lucko.luckperms.common.managers.track.StandardTrackManager;
import me.lucko.luckperms.common.messaging.MessagingFactory;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.AbstractLuckPermsPlugin;
import me.lucko.luckperms.common.sender.DummySender;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.tasks.CacheHousekeepingTask;
import me.lucko.luckperms.common.tasks.ExpireTemporaryTask;
import me.lucko.luckperms.common.treeview.PermissionRegistry;
import me.lucko.luckperms.common.utils.MoreFiles;
import me.lucko.luckperms.sponge.LPSpongeBootstrap;
import me.lucko.luckperms.sponge.SpongeCommandExecutor;
import me.lucko.luckperms.sponge.SpongeConfigAdapter;
import me.lucko.luckperms.sponge.SpongeEventBus;
import me.lucko.luckperms.sponge.SpongeSenderFactory;
import me.lucko.luckperms.sponge.calculators.SpongeCalculatorFactory;
import me.lucko.luckperms.sponge.commands.SpongeMainCommand;
import me.lucko.luckperms.sponge.contexts.SpongeContextManager;
import me.lucko.luckperms.sponge.contexts.WorldCalculator;
import me.lucko.luckperms.sponge.listeners.SpongeConnectionListener;
import me.lucko.luckperms.sponge.listeners.SpongePlatformListener;
import me.lucko.luckperms.sponge.managers.SpongeGroupManager;
import me.lucko.luckperms.sponge.managers.SpongeUserManager;
import me.lucko.luckperms.sponge.messaging.SpongeMessagingFactory;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.event.UpdateEventHandler;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.persisted.PersistedCollection;
import me.lucko.luckperms.sponge.tasks.ServiceCacheHousekeepingTask;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;

public class LPSpongePlugin
extends AbstractLuckPermsPlugin {
    private final LPSpongeBootstrap bootstrap;
    private SpongeSenderFactory senderFactory;
    private SpongeConnectionListener connectionListener;
    private SpongeCommandExecutor commandManager;
    private SpongeUserManager userManager;
    private SpongeGroupManager groupManager;
    private StandardTrackManager trackManager;
    private ContextManager<Subject> contextManager;
    private LuckPermsService service;
    private UpdateEventHandler updateEventHandler;
    private boolean lateLoad = false;

    public LPSpongePlugin(LPSpongeBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Override
    public LPSpongeBootstrap getBootstrap() {
        return this.bootstrap;
    }

    @Override
    protected void setupSenderFactory() {
        this.senderFactory = new SpongeSenderFactory(this);
    }

    @Override
    protected Set<Dependency> getGlobalDependencies() {
        return EnumSet.of(Dependency.TEXT, new Dependency[]{Dependency.CAFFEINE, Dependency.OKIO, Dependency.OKHTTP, Dependency.EVENT, Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_HOCON, Dependency.HOCON_CONFIG});
    }

    @Override
    protected ConfigurationAdapter provideConfigurationAdapter() {
        return new SpongeConfigAdapter(this, this.resolveConfig());
    }

    @Override
    protected void registerPlatformListeners() {
        this.connectionListener = new SpongeConnectionListener(this);
        this.bootstrap.getGame().getEventManager().registerListeners((Object)this.bootstrap, (Object)this.connectionListener);
        this.bootstrap.getGame().getEventManager().registerListeners((Object)this.bootstrap, (Object)new SpongePlatformListener(this));
    }

    @Override
    protected MessagingFactory<?> provideMessagingFactory() {
        return new SpongeMessagingFactory(this);
    }

    @Override
    protected void registerCommands() {
        this.commandManager = new SpongeCommandExecutor(this);
        this.bootstrap.getGame().getCommandManager().register((Object)this.bootstrap, (CommandCallable)this.commandManager, new String[]{"luckperms", "lp", "perm", "perms", "permission", "permissions"});
    }

    @Override
    protected void setupManagers() {
        this.userManager = new SpongeUserManager(this);
        this.groupManager = new SpongeGroupManager(this);
        this.trackManager = new StandardTrackManager(this);
    }

    @Override
    protected CalculatorFactory provideCalculatorFactory() {
        return new SpongeCalculatorFactory(this);
    }

    @Override
    protected void setupContextManager() {
        this.contextManager = new SpongeContextManager(this);
        this.contextManager.registerCalculator(new WorldCalculator(this));
    }

    @Override
    protected void setupPlatformHooks() {
        this.getLogger().info("Registering PermissionService...");
        this.updateEventHandler = UpdateEventHandler.obtain(this);
        this.service = new LuckPermsService(this);
        PermissionRegistry permissionRegistry = this.getPermissionRegistry();
        this.bootstrap.getGame().getServiceManager().provide(PermissionService.class).ifPresent(ps -> ps.getDescriptions().stream().map(PermissionDescription::getId).forEach(permissionRegistry::insert));
        if (this.bootstrap.getGame().getPluginManager().getPlugin("permissionsex").isPresent()) {
            this.getLogger().warn("Detected PermissionsEx - assuming it's loaded for migration.");
            this.getLogger().warn("Delaying LuckPerms PermissionService registration.");
            this.lateLoad = true;
        } else {
            this.bootstrap.getGame().getServiceManager().setProvider((Object)this.bootstrap, LPPermissionService.class, (Object)this.service);
            this.bootstrap.getGame().getServiceManager().setProvider((Object)this.bootstrap, PermissionService.class, (Object)this.service.sponge());
        }
    }

    @Override
    protected AbstractEventBus provideEventBus(LuckPermsApiProvider apiProvider) {
        return new SpongeEventBus(this, apiProvider);
    }

    @Override
    protected void registerApiOnPlatform(LuckPermsApi api) {
        this.bootstrap.getGame().getServiceManager().setProvider((Object)this.bootstrap, LuckPermsApi.class, (Object)api);
    }

    @Override
    protected void registerHousekeepingTasks() {
        this.bootstrap.getScheduler().asyncRepeating(new ExpireTemporaryTask(this), 3L, TimeUnit.SECONDS);
        this.bootstrap.getScheduler().asyncRepeating(new CacheHousekeepingTask(this), 2L, TimeUnit.MINUTES);
        this.bootstrap.getScheduler().asyncRepeating(new ServiceCacheHousekeepingTask(this.service), 2L, TimeUnit.MINUTES);
    }

    @Override
    protected void performFinalSetup() {
        for (CommandPermission perm : CommandPermission.values()) {
            this.service.registerPermissionDescription(perm.getPermission(), null, this.bootstrap.getPluginContainer());
        }
    }

    public void lateEnable() {
        if (this.lateLoad) {
            this.getLogger().info("Providing late registration of PermissionService...");
            this.bootstrap.getGame().getServiceManager().setProvider((Object)this.bootstrap, LPPermissionService.class, (Object)this.service);
            this.bootstrap.getGame().getServiceManager().setProvider((Object)this.bootstrap, PermissionService.class, (Object)this.service.sponge());
        }
    }

    @Override
    public void performPlatformDataSync() {
        for (LPSubjectCollection collection : this.service.getLoadedCollections().values()) {
            if (!(collection instanceof PersistedCollection)) continue;
            ((PersistedCollection)collection).loadAll();
        }
        this.service.invalidateAllCaches();
    }

    private Path resolveConfig() {
        Path path = this.bootstrap.getConfigDirectory().resolve("luckperms.conf");
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                MoreFiles.createDirectoriesIfNotExists(this.bootstrap.getConfigDirectory());
                try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("luckperms.conf");){
                    Files.copy(is, path, new CopyOption[0]);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return path;
    }

    @Override
    public Optional<Contexts> getContextForUser(User user) {
        return this.bootstrap.getPlayer(user.getUuid()).map(player -> this.contextManager.getApplicableContexts((Subject)player));
    }

    @Override
    public Stream<Sender> getOnlineSenders() {
        if (!this.bootstrap.getGame().isServerAvailable()) {
            return Stream.empty();
        }
        return Stream.concat(Stream.of(this.getConsoleSender()), this.bootstrap.getGame().getServer().getOnlinePlayers().stream().map(s -> this.senderFactory.wrap(s)));
    }

    @Override
    public Sender getConsoleSender() {
        if (!this.bootstrap.getGame().isServerAvailable()) {
            return new DummySender(this, CommandManager.CONSOLE_UUID, "Console"){

                @Override
                protected void consumeMessage(String s) {
                    LPSpongePlugin.this.bootstrap.getPluginLogger().info(s);
                }
            };
        }
        return this.senderFactory.wrap(this.bootstrap.getGame().getServer().getConsole());
    }

    @Override
    public List<Command<?, ?>> getExtraCommands() {
        return Collections.singletonList(new SpongeMainCommand(this));
    }

    public SpongeSenderFactory getSenderFactory() {
        return this.senderFactory;
    }

    @Override
    public SpongeConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public SpongeCommandExecutor getCommandManager() {
        return this.commandManager;
    }

    public SpongeUserManager getUserManager() {
        return this.userManager;
    }

    public SpongeGroupManager getGroupManager() {
        return this.groupManager;
    }

    public StandardTrackManager getTrackManager() {
        return this.trackManager;
    }

    public ContextManager<Subject> getContextManager() {
        return this.contextManager;
    }

    public LuckPermsService getService() {
        return this.service;
    }

    public UpdateEventHandler getUpdateEventHandler() {
        return this.updateEventHandler;
    }
}

