/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;
import me.lucko.luckperms.common.utils.Iterators;
import me.lucko.luckperms.sponge.LPSpongeBootstrap;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.SpongeExecutorService;
import org.spongepowered.api.scheduler.Task;

public class SpongeSchedulerAdapter
implements SchedulerAdapter {
    private final LPSpongeBootstrap bootstrap;
    private final Scheduler scheduler;
    private final SpongeExecutorService sync;
    private final SpongeExecutorService async;
    private final Set<Task> tasks = Collections.newSetFromMap(new WeakHashMap());

    public SpongeSchedulerAdapter(LPSpongeBootstrap bootstrap, Scheduler scheduler, SpongeExecutorService sync, SpongeExecutorService async) {
        this.bootstrap = bootstrap;
        this.scheduler = scheduler;
        this.sync = sync;
        this.async = async;
    }

    @Override
    public Executor async() {
        return this.async;
    }

    @Override
    public Executor sync() {
        return this.sync;
    }

    @Override
    public void executeAsync(Runnable runnable) {
        this.scheduler.createTaskBuilder().async().execute(runnable).submit((Object)this.bootstrap);
    }

    @Override
    public void executeSync(Runnable runnable) {
        this.scheduler.createTaskBuilder().execute(runnable).submit((Object)this.bootstrap);
    }

    @Override
    public SchedulerTask asyncLater(Runnable task, long delay, TimeUnit unit) {
        Task t = this.scheduler.createTaskBuilder().async().delay(delay, unit).execute(task).submit((Object)this.bootstrap);
        this.tasks.add(t);
        return () -> ((Task)t).cancel();
    }

    @Override
    public SchedulerTask asyncRepeating(Runnable task, long interval, TimeUnit unit) {
        Task t = this.scheduler.createTaskBuilder().async().interval(interval, unit).delay(interval, unit).execute(task).submit((Object)this.bootstrap);
        this.tasks.add(t);
        return () -> ((Task)t).cancel();
    }

    @Override
    public void shutdown() {
        Iterators.iterate(this.tasks, Task::cancel);
    }
}

